package org.wildfly.swarm.config.discovery;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Map;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * A static discovery provider definition
 */
@Address("/subsystem=discovery/static-provider=*")
@ResourceType("static-provider")
public class StaticProvider<T extends StaticProvider<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The list of services that are configured with this provider")
	private List<java.util.Map> services;

	public StaticProvider(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The list of services that are configured with this provider
	 */
	@ModelNodeBinding(detypedName = "services")
	public List<Map> services() {
		return this.services;
	}

	/**
	 * The list of services that are configured with this provider
	 */
	@SuppressWarnings("unchecked")
	public T services(java.util.List<java.util.Map> value) {
		Object oldValue = this.services;
		this.services = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("services", oldValue, value);
		return (T) this;
	}

	/**
	 * The list of services that are configured with this provider
	 */
	@SuppressWarnings("unchecked")
	public T service(java.util.Map value) {
		if (this.services == null) {
			this.services = new java.util.ArrayList<>();
		}
		this.services.add(value);
		return (T) this;
	}

	/**
	 * The list of services that are configured with this provider
	 */
	@SuppressWarnings("unchecked")
	public T services(java.util.Map... args) {
		services(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}
}