package org.wildfly.swarm.config.discovery;

import org.wildfly.swarm.config.discovery.StaticProvider;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface StaticProviderConsumer<T extends StaticProvider<T>> {

	/**
	 * Configure a pre-constructed instance of StaticProvider resource
	 * 
	 * @parameter Instance of StaticProvider to configure
	 * @return nothing
	 */
	void accept(T value);

	default StaticProviderConsumer<T> andThen(StaticProviderConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}