package org.wildfly.swarm.config.ejb3;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * A clustered passivation store
 */
@Address("/subsystem=ejb3/cluster-passivation-store=*")
@ResourceType("cluster-passivation-store")
public class ClusterPassivationStore<T extends ClusterPassivationStore<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The name of the cache used to store bean instances.")
	private String beanCache;
	@AttributeDocumentation("The name of the cache container used for the bean and client-mappings caches")
	private String cacheContainer;
	@AttributeDocumentation("The name of the cache used to store client-mappings of the EJB remoting connector's socket-bindings")
	private String clientMappingsCache;
	@AttributeDocumentation("The timeout in units specified by idle-timeout-unit, after which a bean will passivate")
	private Long idleTimeout;
	@AttributeDocumentation("The unit of idle-timeout")
	private String idleTimeoutUnit;
	@AttributeDocumentation("The maximum number of beans this cache should store before forcing old beans to passivate")
	private Integer maxSize;
	@AttributeDocumentation("Indicates whether replication should trigger passivation events on the bean")
	private Boolean passivateEventsOnReplicate;

	public ClusterPassivationStore(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The name of the cache used to store bean instances.
	 */
	@ModelNodeBinding(detypedName = "bean-cache")
	public String beanCache() {
		return this.beanCache;
	}

	/**
	 * The name of the cache used to store bean instances.
	 */
	@SuppressWarnings("unchecked")
	public T beanCache(java.lang.String value) {
		Object oldValue = this.beanCache;
		this.beanCache = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("beanCache", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the cache container used for the bean and client-mappings
	 * caches
	 */
	@ModelNodeBinding(detypedName = "cache-container")
	public String cacheContainer() {
		return this.cacheContainer;
	}

	/**
	 * The name of the cache container used for the bean and client-mappings
	 * caches
	 */
	@SuppressWarnings("unchecked")
	public T cacheContainer(java.lang.String value) {
		Object oldValue = this.cacheContainer;
		this.cacheContainer = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("cacheContainer", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the cache used to store client-mappings of the EJB remoting
	 * connector's socket-bindings
	 * 
	 * @deprecated This is no longer configurable and will be ignored
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "client-mappings-cache")
	public String clientMappingsCache() {
		return this.clientMappingsCache;
	}

	/**
	 * The name of the cache used to store client-mappings of the EJB remoting
	 * connector's socket-bindings
	 * 
	 * @deprecated This is no longer configurable and will be ignored
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T clientMappingsCache(java.lang.String value) {
		Object oldValue = this.clientMappingsCache;
		this.clientMappingsCache = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("clientMappingsCache", oldValue, value);
		return (T) this;
	}

	/**
	 * The timeout in units specified by idle-timeout-unit, after which a bean
	 * will passivate
	 */
	@ModelNodeBinding(detypedName = "idle-timeout")
	public Long idleTimeout() {
		return this.idleTimeout;
	}

	/**
	 * The timeout in units specified by idle-timeout-unit, after which a bean
	 * will passivate
	 */
	@SuppressWarnings("unchecked")
	public T idleTimeout(java.lang.Long value) {
		Object oldValue = this.idleTimeout;
		this.idleTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("idleTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * The unit of idle-timeout
	 * 
	 * @deprecated SFSBs are no longer passivated eagerly, but only lazily as
	 *             required by max-size
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "idle-timeout-unit")
	public String idleTimeoutUnit() {
		return this.idleTimeoutUnit;
	}

	/**
	 * The unit of idle-timeout
	 * 
	 * @deprecated SFSBs are no longer passivated eagerly, but only lazily as
	 *             required by max-size
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T idleTimeoutUnit(java.lang.String value) {
		Object oldValue = this.idleTimeoutUnit;
		this.idleTimeoutUnit = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("idleTimeoutUnit", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum number of beans this cache should store before forcing old
	 * beans to passivate
	 */
	@ModelNodeBinding(detypedName = "max-size")
	public Integer maxSize() {
		return this.maxSize;
	}

	/**
	 * The maximum number of beans this cache should store before forcing old
	 * beans to passivate
	 */
	@SuppressWarnings("unchecked")
	public T maxSize(java.lang.Integer value) {
		Object oldValue = this.maxSize;
		this.maxSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxSize", oldValue, value);
		return (T) this;
	}

	/**
	 * Indicates whether replication should trigger passivation events on the
	 * bean
	 * 
	 * @deprecated This is no longer configurable and will be ignored
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "passivate-events-on-replicate")
	public Boolean passivateEventsOnReplicate() {
		return this.passivateEventsOnReplicate;
	}

	/**
	 * Indicates whether replication should trigger passivation events on the
	 * bean
	 * 
	 * @deprecated This is no longer configurable and will be ignored
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T passivateEventsOnReplicate(java.lang.Boolean value) {
		Object oldValue = this.passivateEventsOnReplicate;
		this.passivateEventsOnReplicate = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("passivateEventsOnReplicate", oldValue,
					value);
		return (T) this;
	}
}