package org.wildfly.swarm.config.ejb3;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * A file system based passivation store
 */
@Address("/subsystem=ejb3/file-passivation-store=*")
@ResourceType("file-passivation-store")
public class FilePassivationStore<T extends FilePassivationStore<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The subdirectory within the path specified by relative-to in which to store passivated bean groups")
	private String groupsPath;
	@AttributeDocumentation("The timeout in units specified by idle-timeout-unit, after which a bean will passivate")
	private Long idleTimeout;
	@AttributeDocumentation("The unit of idle-timeout")
	private String idleTimeoutUnit;
	@AttributeDocumentation("The maximum number of beans this cache should store before forcing old beans to passivate")
	private Integer maxSize;
	@AttributeDocumentation("The root path used to store passivated beans")
	private String relativeTo;
	@AttributeDocumentation("The subdirectory within the path specified by relative-to in which to store passivated beans")
	private String sessionsPath;
	@AttributeDocumentation("Specifies the number of subdirectories into which stored state should be divided, used to minimize the number of files created per directory")
	private Long subdirectoryCount;

	public FilePassivationStore(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The subdirectory within the path specified by relative-to in which to
	 * store passivated bean groups
	 * 
	 * @deprecated Beans and bean groups are no longer stored in distinct
	 *             directories
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "groups-path")
	public String groupsPath() {
		return this.groupsPath;
	}

	/**
	 * The subdirectory within the path specified by relative-to in which to
	 * store passivated bean groups
	 * 
	 * @deprecated Beans and bean groups are no longer stored in distinct
	 *             directories
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T groupsPath(java.lang.String value) {
		Object oldValue = this.groupsPath;
		this.groupsPath = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("groupsPath", oldValue, value);
		return (T) this;
	}

	/**
	 * The timeout in units specified by idle-timeout-unit, after which a bean
	 * will passivate
	 */
	@ModelNodeBinding(detypedName = "idle-timeout")
	public Long idleTimeout() {
		return this.idleTimeout;
	}

	/**
	 * The timeout in units specified by idle-timeout-unit, after which a bean
	 * will passivate
	 */
	@SuppressWarnings("unchecked")
	public T idleTimeout(java.lang.Long value) {
		Object oldValue = this.idleTimeout;
		this.idleTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("idleTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * The unit of idle-timeout
	 * 
	 * @deprecated SFSBs are no longer passivated eagerly, but only lazily as
	 *             required by max-size
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "idle-timeout-unit")
	public String idleTimeoutUnit() {
		return this.idleTimeoutUnit;
	}

	/**
	 * The unit of idle-timeout
	 * 
	 * @deprecated SFSBs are no longer passivated eagerly, but only lazily as
	 *             required by max-size
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T idleTimeoutUnit(java.lang.String value) {
		Object oldValue = this.idleTimeoutUnit;
		this.idleTimeoutUnit = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("idleTimeoutUnit", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum number of beans this cache should store before forcing old
	 * beans to passivate
	 */
	@ModelNodeBinding(detypedName = "max-size")
	public Integer maxSize() {
		return this.maxSize;
	}

	/**
	 * The maximum number of beans this cache should store before forcing old
	 * beans to passivate
	 */
	@SuppressWarnings("unchecked")
	public T maxSize(java.lang.Integer value) {
		Object oldValue = this.maxSize;
		this.maxSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The root path used to store passivated beans
	 * 
	 * @deprecated Use the relative-to attribute of the file-store of the
	 *             relevant infinispan cache instead
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "relative-to")
	public String relativeTo() {
		return this.relativeTo;
	}

	/**
	 * The root path used to store passivated beans
	 * 
	 * @deprecated Use the relative-to attribute of the file-store of the
	 *             relevant infinispan cache instead
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T relativeTo(java.lang.String value) {
		Object oldValue = this.relativeTo;
		this.relativeTo = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("relativeTo", oldValue, value);
		return (T) this;
	}

	/**
	 * The subdirectory within the path specified by relative-to in which to
	 * store passivated beans
	 * 
	 * @deprecated Beans and bean groups are no longer stored in distinct
	 *             directories
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "sessions-path")
	public String sessionsPath() {
		return this.sessionsPath;
	}

	/**
	 * The subdirectory within the path specified by relative-to in which to
	 * store passivated beans
	 * 
	 * @deprecated Beans and bean groups are no longer stored in distinct
	 *             directories
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T sessionsPath(java.lang.String value) {
		Object oldValue = this.sessionsPath;
		this.sessionsPath = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("sessionsPath", oldValue, value);
		return (T) this;
	}

	/**
	 * Specifies the number of subdirectories into which stored state should be
	 * divided, used to minimize the number of files created per directory
	 * 
	 * @deprecated This is no longer configurable and will be ignored
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "subdirectory-count")
	public Long subdirectoryCount() {
		return this.subdirectoryCount;
	}

	/**
	 * Specifies the number of subdirectories into which stored state should be
	 * divided, used to minimize the number of files created per directory
	 * 
	 * @deprecated This is no longer configurable and will be ignored
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T subdirectoryCount(java.lang.Long value) {
		Object oldValue = this.subdirectoryCount;
		this.subdirectoryCount = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("subdirectoryCount", oldValue, value);
		return (T) this;
	}
}