package org.wildfly.swarm.config.ejb3;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * Identity definition for security identity propagation
 */
@Address("/subsystem=ejb3/service=identity")
@ResourceType("service")
@Implicit
public class IdentityService<T extends IdentityService<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("References to security domains to attempt to outflow any established identity to")
	private List<String> outflowSecurityDomains;

	public IdentityService() {
		super();
		this.key = "identity";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * References to security domains to attempt to outflow any established
	 * identity to
	 */
	@ModelNodeBinding(detypedName = "outflow-security-domains")
	public List<String> outflowSecurityDomains() {
		return this.outflowSecurityDomains;
	}

	/**
	 * References to security domains to attempt to outflow any established
	 * identity to
	 */
	@SuppressWarnings("unchecked")
	public T outflowSecurityDomains(java.util.List<String> value) {
		Object oldValue = this.outflowSecurityDomains;
		this.outflowSecurityDomains = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("outflowSecurityDomains", oldValue,
					value);
		return (T) this;
	}

	/**
	 * References to security domains to attempt to outflow any established
	 * identity to
	 */
	@SuppressWarnings("unchecked")
	public T outflowSecurityDomain(String value) {
		if (this.outflowSecurityDomains == null) {
			this.outflowSecurityDomains = new java.util.ArrayList<>();
		}
		this.outflowSecurityDomains.add(value);
		return (T) this;
	}

	/**
	 * References to security domains to attempt to outflow any established
	 * identity to
	 */
	@SuppressWarnings("unchecked")
	public T outflowSecurityDomains(String... args) {
		outflowSecurityDomains(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}
}