package org.wildfly.swarm.config.ejb3;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;

/**
 * A thread pool executor with an enhanced queue. In such a thread pool, its
 * core and max size are configured independently, idle threads are always
 * reused when available, and threads count is kept to a minimum.
 */
@Address("/subsystem=ejb3/thread-pool=*")
@ResourceType("thread-pool")
public class ThreadPool<T extends ThreadPool<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The approximate number of threads that are actively executing tasks.")
	private Integer activeCount;
	@AttributeDocumentation("The approximate total number of tasks that have completed execution.")
	private Integer completedTaskCount;
	@AttributeDocumentation("The core thread pool size which is smaller than the maximum pool size. If undefined, the core thread pool size is the same as the maximum thread pool size.")
	private Integer coreThreads;
	@AttributeDocumentation("The current number of threads in the pool.")
	private Integer currentThreadCount;
	@AttributeDocumentation("Used to specify the amount of time that pool threads should be kept running when idle; if not specified, threads will run until the executor is shut down.")
	private Map keepaliveTime;
	@AttributeDocumentation("The largest number of threads that have ever simultaneously been in the pool.")
	private Integer largestThreadCount;
	@AttributeDocumentation("The maximum thread pool size.")
	private Integer maxThreads;
	@AttributeDocumentation("The name of the thread pool.")
	private String name;
	@AttributeDocumentation("The queue size.")
	private Integer queueSize;
	@AttributeDocumentation("The number of tasks that have been rejected.")
	private Integer rejectedCount;
	@AttributeDocumentation("The approximate total number of tasks that have ever been scheduled for execution.")
	private Integer taskCount;
	@AttributeDocumentation("Specifies the name of a specific thread factory to use to create worker threads. If not defined an appropriate default thread factory will be used.")
	private String threadFactory;

	public ThreadPool(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The approximate number of threads that are actively executing tasks.
	 */
	@ModelNodeBinding(detypedName = "active-count")
	public Integer activeCount() {
		return this.activeCount;
	}

	/**
	 * The approximate number of threads that are actively executing tasks.
	 */
	@SuppressWarnings("unchecked")
	public T activeCount(java.lang.Integer value) {
		Object oldValue = this.activeCount;
		this.activeCount = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("activeCount", oldValue, value);
		return (T) this;
	}

	/**
	 * The approximate total number of tasks that have completed execution.
	 */
	@ModelNodeBinding(detypedName = "completed-task-count")
	public Integer completedTaskCount() {
		return this.completedTaskCount;
	}

	/**
	 * The approximate total number of tasks that have completed execution.
	 */
	@SuppressWarnings("unchecked")
	public T completedTaskCount(java.lang.Integer value) {
		Object oldValue = this.completedTaskCount;
		this.completedTaskCount = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("completedTaskCount", oldValue, value);
		return (T) this;
	}

	/**
	 * The core thread pool size which is smaller than the maximum pool size. If
	 * undefined, the core thread pool size is the same as the maximum thread
	 * pool size.
	 */
	@ModelNodeBinding(detypedName = "core-threads")
	public Integer coreThreads() {
		return this.coreThreads;
	}

	/**
	 * The core thread pool size which is smaller than the maximum pool size. If
	 * undefined, the core thread pool size is the same as the maximum thread
	 * pool size.
	 */
	@SuppressWarnings("unchecked")
	public T coreThreads(java.lang.Integer value) {
		Object oldValue = this.coreThreads;
		this.coreThreads = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("coreThreads", oldValue, value);
		return (T) this;
	}

	/**
	 * The current number of threads in the pool.
	 */
	@ModelNodeBinding(detypedName = "current-thread-count")
	public Integer currentThreadCount() {
		return this.currentThreadCount;
	}

	/**
	 * The current number of threads in the pool.
	 */
	@SuppressWarnings("unchecked")
	public T currentThreadCount(java.lang.Integer value) {
		Object oldValue = this.currentThreadCount;
		this.currentThreadCount = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("currentThreadCount", oldValue, value);
		return (T) this;
	}

	/**
	 * Used to specify the amount of time that pool threads should be kept
	 * running when idle; if not specified, threads will run until the executor
	 * is shut down.
	 */
	@ModelNodeBinding(detypedName = "keepalive-time")
	public Map keepaliveTime() {
		return this.keepaliveTime;
	}

	/**
	 * Used to specify the amount of time that pool threads should be kept
	 * running when idle; if not specified, threads will run until the executor
	 * is shut down.
	 */
	@SuppressWarnings("unchecked")
	public T keepaliveTime(java.util.Map value) {
		Object oldValue = this.keepaliveTime;
		this.keepaliveTime = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keepaliveTime", oldValue, value);
		return (T) this;
	}

	/**
	 * Used to specify the amount of time that pool threads should be kept
	 * running when idle; if not specified, threads will run until the executor
	 * is shut down.
	 */
	@SuppressWarnings("unchecked")
	public T keepaliveTime(java.lang.String key, java.lang.Object value) {
		if (this.keepaliveTime == null) {
			this.keepaliveTime = new java.util.HashMap<>();
		}
		this.keepaliveTime.put(key, value);
		return (T) this;
	}

	/**
	 * The largest number of threads that have ever simultaneously been in the
	 * pool.
	 */
	@ModelNodeBinding(detypedName = "largest-thread-count")
	public Integer largestThreadCount() {
		return this.largestThreadCount;
	}

	/**
	 * The largest number of threads that have ever simultaneously been in the
	 * pool.
	 */
	@SuppressWarnings("unchecked")
	public T largestThreadCount(java.lang.Integer value) {
		Object oldValue = this.largestThreadCount;
		this.largestThreadCount = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("largestThreadCount", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum thread pool size.
	 */
	@ModelNodeBinding(detypedName = "max-threads")
	public Integer maxThreads() {
		return this.maxThreads;
	}

	/**
	 * The maximum thread pool size.
	 */
	@SuppressWarnings("unchecked")
	public T maxThreads(java.lang.Integer value) {
		Object oldValue = this.maxThreads;
		this.maxThreads = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxThreads", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the thread pool.
	 */
	@ModelNodeBinding(detypedName = "name")
	public String name() {
		return this.name;
	}

	/**
	 * The name of the thread pool.
	 */
	@SuppressWarnings("unchecked")
	public T name(java.lang.String value) {
		Object oldValue = this.name;
		this.name = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("name", oldValue, value);
		return (T) this;
	}

	/**
	 * The queue size.
	 */
	@ModelNodeBinding(detypedName = "queue-size")
	public Integer queueSize() {
		return this.queueSize;
	}

	/**
	 * The queue size.
	 */
	@SuppressWarnings("unchecked")
	public T queueSize(java.lang.Integer value) {
		Object oldValue = this.queueSize;
		this.queueSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("queueSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of tasks that have been rejected.
	 */
	@ModelNodeBinding(detypedName = "rejected-count")
	public Integer rejectedCount() {
		return this.rejectedCount;
	}

	/**
	 * The number of tasks that have been rejected.
	 */
	@SuppressWarnings("unchecked")
	public T rejectedCount(java.lang.Integer value) {
		Object oldValue = this.rejectedCount;
		this.rejectedCount = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("rejectedCount", oldValue, value);
		return (T) this;
	}

	/**
	 * The approximate total number of tasks that have ever been scheduled for
	 * execution.
	 */
	@ModelNodeBinding(detypedName = "task-count")
	public Integer taskCount() {
		return this.taskCount;
	}

	/**
	 * The approximate total number of tasks that have ever been scheduled for
	 * execution.
	 */
	@SuppressWarnings("unchecked")
	public T taskCount(java.lang.Integer value) {
		Object oldValue = this.taskCount;
		this.taskCount = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("taskCount", oldValue, value);
		return (T) this;
	}

	/**
	 * Specifies the name of a specific thread factory to use to create worker
	 * threads. If not defined an appropriate default thread factory will be
	 * used.
	 */
	@ModelNodeBinding(detypedName = "thread-factory")
	public String threadFactory() {
		return this.threadFactory;
	}

	/**
	 * Specifies the name of a specific thread factory to use to create worker
	 * threads. If not defined an appropriate default thread factory will be
	 * used.
	 */
	@SuppressWarnings("unchecked")
	public T threadFactory(java.lang.String value) {
		Object oldValue = this.threadFactory;
		this.threadFactory = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("threadFactory", oldValue, value);
		return (T) this;
	}
}