package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * An evidence decoder that is an aggregation of other evidence decoders. Given
 * evidence, these evidence decoders will be attempted in order until one
 * returns a non-null principal or until there are no more evidence decoders
 * left to try.
 */
@Address("/subsystem=elytron/aggregate-evidence-decoder=*")
@ResourceType("aggregate-evidence-decoder")
public class AggregateEvidenceDecoder<T extends AggregateEvidenceDecoder<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The referenced evidence decoders to aggregate.")
	private List<String> evidenceDecoders;

	public AggregateEvidenceDecoder(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The referenced evidence decoders to aggregate.
	 */
	@ModelNodeBinding(detypedName = "evidence-decoders")
	public List<String> evidenceDecoders() {
		return this.evidenceDecoders;
	}

	/**
	 * The referenced evidence decoders to aggregate.
	 */
	@SuppressWarnings("unchecked")
	public T evidenceDecoders(java.util.List<String> value) {
		Object oldValue = this.evidenceDecoders;
		this.evidenceDecoders = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("evidenceDecoders", oldValue, value);
		return (T) this;
	}

	/**
	 * The referenced evidence decoders to aggregate.
	 */
	@SuppressWarnings("unchecked")
	public T evidenceDecoder(String value) {
		if (this.evidenceDecoders == null) {
			this.evidenceDecoders = new java.util.ArrayList<>();
		}
		this.evidenceDecoders.add(value);
		return (T) this;
	}

	/**
	 * The referenced evidence decoders to aggregate.
	 */
	@SuppressWarnings("unchecked")
	public T evidenceDecoders(String... args) {
		evidenceDecoders(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}
}