package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.AggregateEvidenceDecoder;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface AggregateEvidenceDecoderConsumer<T extends AggregateEvidenceDecoder<T>> {

	/**
	 * Configure a pre-constructed instance of AggregateEvidenceDecoder resource
	 * 
	 * @parameter Instance of AggregateEvidenceDecoder to configure
	 * @return nothing
	 */
	void accept(T value);

	default AggregateEvidenceDecoderConsumer<T> andThen(
			AggregateEvidenceDecoderConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}