package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.AggregatePrincipalDecoder;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface AggregatePrincipalDecoderConsumer<T extends AggregatePrincipalDecoder<T>> {

	/**
	 * Configure a pre-constructed instance of AggregatePrincipalDecoder
	 * resource
	 * 
	 * @parameter Instance of AggregatePrincipalDecoder to configure
	 * @return nothing
	 */
	void accept(T value);

	default AggregatePrincipalDecoderConsumer<T> andThen(
			AggregatePrincipalDecoderConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}