package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * A realm definition that is an aggregation of two realms, one for the
 * authentication steps and one for loading the identity for the authorization
 * steps.
 */
@Address("/subsystem=elytron/aggregate-realm=*")
@ResourceType("aggregate-realm")
public class AggregateRealm<T extends AggregateRealm<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Reference to the security realm to use for authentication steps (obtaining or validating credentials).")
	private String authenticationRealm;
	@AttributeDocumentation("Reference to the security realm to use for loading the identity for authorization steps (loading of the identity).")
	private String authorizationRealm;
	@AttributeDocumentation("Reference to one or more security realms to use for loading the identity for authorization steps and aggregating the attributes (loading of the identity).")
	private List<String> authorizationRealms;
	@AttributeDocumentation("Reference to a principal transformer to apply between loading the identity for authentication and loading the identity for authorization")
	private String principalTransformer;

	public AggregateRealm(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Reference to the security realm to use for authentication steps
	 * (obtaining or validating credentials).
	 */
	@ModelNodeBinding(detypedName = "authentication-realm")
	public String authenticationRealm() {
		return this.authenticationRealm;
	}

	/**
	 * Reference to the security realm to use for authentication steps
	 * (obtaining or validating credentials).
	 */
	@SuppressWarnings("unchecked")
	public T authenticationRealm(java.lang.String value) {
		Object oldValue = this.authenticationRealm;
		this.authenticationRealm = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("authenticationRealm", oldValue, value);
		return (T) this;
	}

	/**
	 * Reference to the security realm to use for loading the identity for
	 * authorization steps (loading of the identity).
	 */
	@ModelNodeBinding(detypedName = "authorization-realm")
	public String authorizationRealm() {
		return this.authorizationRealm;
	}

	/**
	 * Reference to the security realm to use for loading the identity for
	 * authorization steps (loading of the identity).
	 */
	@SuppressWarnings("unchecked")
	public T authorizationRealm(java.lang.String value) {
		Object oldValue = this.authorizationRealm;
		this.authorizationRealm = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("authorizationRealm", oldValue, value);
		return (T) this;
	}

	/**
	 * Reference to one or more security realms to use for loading the identity
	 * for authorization steps and aggregating the attributes (loading of the
	 * identity).
	 */
	@ModelNodeBinding(detypedName = "authorization-realms")
	public List<String> authorizationRealms() {
		return this.authorizationRealms;
	}

	/**
	 * Reference to one or more security realms to use for loading the identity
	 * for authorization steps and aggregating the attributes (loading of the
	 * identity).
	 */
	@SuppressWarnings("unchecked")
	public T authorizationRealms(java.util.List<String> value) {
		Object oldValue = this.authorizationRealms;
		this.authorizationRealms = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("authorizationRealms", oldValue, value);
		return (T) this;
	}

	/**
	 * Reference to one or more security realms to use for loading the identity
	 * for authorization steps and aggregating the attributes (loading of the
	 * identity).
	 */
	@SuppressWarnings("unchecked")
	public T authorizationRealmAppend(String value) {
		if (this.authorizationRealms == null) {
			this.authorizationRealms = new java.util.ArrayList<>();
		}
		this.authorizationRealms.add(value);
		return (T) this;
	}

	/**
	 * Reference to one or more security realms to use for loading the identity
	 * for authorization steps and aggregating the attributes (loading of the
	 * identity).
	 */
	@SuppressWarnings("unchecked")
	public T authorizationRealms(String... args) {
		authorizationRealms(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * Reference to a principal transformer to apply between loading the
	 * identity for authentication and loading the identity for authorization
	 */
	@ModelNodeBinding(detypedName = "principal-transformer")
	public String principalTransformer() {
		return this.principalTransformer;
	}

	/**
	 * Reference to a principal transformer to apply between loading the
	 * identity for authentication and loading the identity for authorization
	 */
	@SuppressWarnings("unchecked")
	public T principalTransformer(java.lang.String value) {
		Object oldValue = this.principalTransformer;
		this.principalTransformer = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("principalTransformer", oldValue, value);
		return (T) this;
	}
}