package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.AggregateRoleMapper;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface AggregateRoleMapperConsumer<T extends AggregateRoleMapper<T>> {

	/**
	 * Configure a pre-constructed instance of AggregateRoleMapper resource
	 * 
	 * @parameter Instance of AggregateRoleMapper to configure
	 * @return nothing
	 */
	void accept(T value);

	default AggregateRoleMapperConsumer<T> andThen(
			AggregateRoleMapperConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}