package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * A certificate authority definition.
 */
@Address("/subsystem=elytron/certificate-authority=*")
@ResourceType("certificate-authority")
public class CertificateAuthority<T extends CertificateAuthority<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("URL of the certificate authority to use in pre-production.")
	private String stagingUrl;
	@AttributeDocumentation("URL of the certificate authority.")
	private String url;

	public CertificateAuthority(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * URL of the certificate authority to use in pre-production.
	 */
	@ModelNodeBinding(detypedName = "staging-url")
	public String stagingUrl() {
		return this.stagingUrl;
	}

	/**
	 * URL of the certificate authority to use in pre-production.
	 */
	@SuppressWarnings("unchecked")
	public T stagingUrl(java.lang.String value) {
		Object oldValue = this.stagingUrl;
		this.stagingUrl = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("stagingUrl", oldValue, value);
		return (T) this;
	}

	/**
	 * URL of the certificate authority.
	 */
	@ModelNodeBinding(detypedName = "url")
	public String url() {
		return this.url;
	}

	/**
	 * URL of the certificate authority.
	 */
	@SuppressWarnings("unchecked")
	public T url(java.lang.String value) {
		Object oldValue = this.url;
		this.url = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("url", oldValue, value);
		return (T) this;
	}
}