package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.Map;

/**
 * A certificate authority account definition.
 */
@Address("/subsystem=elytron/certificate-authority-account=*")
@ResourceType("certificate-authority-account")
public class CertificateAuthorityAccount<T extends CertificateAuthorityAccount<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The alias of certificate authority account key in the keystore. If the alias does not already exist in the keystore, a certificate authority account key will be automatically generated and stored as a PrivateKeyEntry under the alias.")
	private String alias;
	@AttributeDocumentation("The name of the certificate authority to use.")
	private String certificateAuthority;
	@AttributeDocumentation("A list of URLs that the certificate authority can contact about any issues related to this account.")
	private List<String> contactUrls;
	@AttributeDocumentation("Credential to be used when accessing the certificate authority account key.")
	private Map credentialReference;
	@AttributeDocumentation("The keystore that contains the certificate authority account key.")
	private String keyStore;

	public CertificateAuthorityAccount(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The alias of certificate authority account key in the keystore. If the
	 * alias does not already exist in the keystore, a certificate authority
	 * account key will be automatically generated and stored as a
	 * PrivateKeyEntry under the alias.
	 */
	@ModelNodeBinding(detypedName = "alias")
	public String alias() {
		return this.alias;
	}

	/**
	 * The alias of certificate authority account key in the keystore. If the
	 * alias does not already exist in the keystore, a certificate authority
	 * account key will be automatically generated and stored as a
	 * PrivateKeyEntry under the alias.
	 */
	@SuppressWarnings("unchecked")
	public T alias(java.lang.String value) {
		Object oldValue = this.alias;
		this.alias = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("alias", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the certificate authority to use.
	 */
	@ModelNodeBinding(detypedName = "certificate-authority")
	public String certificateAuthority() {
		return this.certificateAuthority;
	}

	/**
	 * The name of the certificate authority to use.
	 */
	@SuppressWarnings("unchecked")
	public T certificateAuthority(java.lang.String value) {
		Object oldValue = this.certificateAuthority;
		this.certificateAuthority = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("certificateAuthority", oldValue, value);
		return (T) this;
	}

	/**
	 * A list of URLs that the certificate authority can contact about any
	 * issues related to this account.
	 */
	@ModelNodeBinding(detypedName = "contact-urls")
	public List<String> contactUrls() {
		return this.contactUrls;
	}

	/**
	 * A list of URLs that the certificate authority can contact about any
	 * issues related to this account.
	 */
	@SuppressWarnings("unchecked")
	public T contactUrls(java.util.List<String> value) {
		Object oldValue = this.contactUrls;
		this.contactUrls = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("contactUrls", oldValue, value);
		return (T) this;
	}

	/**
	 * A list of URLs that the certificate authority can contact about any
	 * issues related to this account.
	 */
	@SuppressWarnings("unchecked")
	public T contactUrl(String value) {
		if (this.contactUrls == null) {
			this.contactUrls = new java.util.ArrayList<>();
		}
		this.contactUrls.add(value);
		return (T) this;
	}

	/**
	 * A list of URLs that the certificate authority can contact about any
	 * issues related to this account.
	 */
	@SuppressWarnings("unchecked")
	public T contactUrls(String... args) {
		contactUrls(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * Credential to be used when accessing the certificate authority account
	 * key.
	 */
	@ModelNodeBinding(detypedName = "credential-reference")
	public Map credentialReference() {
		return this.credentialReference;
	}

	/**
	 * Credential to be used when accessing the certificate authority account
	 * key.
	 */
	@SuppressWarnings("unchecked")
	public T credentialReference(java.util.Map value) {
		Object oldValue = this.credentialReference;
		this.credentialReference = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("credentialReference", oldValue, value);
		return (T) this;
	}

	/**
	 * Credential to be used when accessing the certificate authority account
	 * key.
	 */
	@SuppressWarnings("unchecked")
	public T credentialReference(java.lang.String key, java.lang.Object value) {
		if (this.credentialReference == null) {
			this.credentialReference = new java.util.HashMap<>();
		}
		this.credentialReference.put(key, value);
		return (T) this;
	}

	/**
	 * The keystore that contains the certificate authority account key.
	 */
	@ModelNodeBinding(detypedName = "key-store")
	public String keyStore() {
		return this.keyStore;
	}

	/**
	 * The keystore that contains the certificate authority account key.
	 */
	@SuppressWarnings("unchecked")
	public T keyStore(java.lang.String value) {
		Object oldValue = this.keyStore;
		this.keyStore = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keyStore", oldValue, value);
		return (T) this;
	}
}