package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.CertificateAuthority;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface CertificateAuthorityConsumer<T extends CertificateAuthority<T>> {

	/**
	 * Configure a pre-constructed instance of CertificateAuthority resource
	 * 
	 * @parameter Instance of CertificateAuthority to configure
	 * @return nothing
	 */
	void accept(T value);

	default CertificateAuthorityConsumer<T> andThen(
			CertificateAuthorityConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}