package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.Map;

/**
 * A SaslServerFactory definition that wraps another SaslServerFactory and
 * applies the specified configuration and filtering.
 */
@Address("/subsystem=elytron/configurable-sasl-server-factory=*")
@ResourceType("configurable-sasl-server-factory")
public class ConfigurableSASLServerFactory<T extends ConfigurableSASLServerFactory<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The SASL mechanisms available from this factory after all filtering has been applied.")
	private List<String> availableMechanisms;
	@AttributeDocumentation("List of filters to be evaluated sequentially combining the results using 'or'.")
	private List<java.util.Map> filters;
	@AttributeDocumentation("Custom properties to be passed in to the sasl server factory calls.")
	private Map properties;
	@AttributeDocumentation("The protocol that should be passed into factory when creating the mechanism.")
	private String protocol;
	@AttributeDocumentation("The sasl server factory to be wrapped.")
	private String saslServerFactory;
	@AttributeDocumentation("The server name that should be passed into factory when creating the mechanism.")
	private String serverName;

	public ConfigurableSASLServerFactory(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The SASL mechanisms available from this factory after all filtering has
	 * been applied.
	 */
	@ModelNodeBinding(detypedName = "available-mechanisms")
	public List<String> availableMechanisms() {
		return this.availableMechanisms;
	}

	/**
	 * The SASL mechanisms available from this factory after all filtering has
	 * been applied.
	 */
	@SuppressWarnings("unchecked")
	public T availableMechanisms(java.util.List<String> value) {
		Object oldValue = this.availableMechanisms;
		this.availableMechanisms = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("availableMechanisms", oldValue, value);
		return (T) this;
	}

	/**
	 * The SASL mechanisms available from this factory after all filtering has
	 * been applied.
	 */
	@SuppressWarnings("unchecked")
	public T availableMechanism(String value) {
		if (this.availableMechanisms == null) {
			this.availableMechanisms = new java.util.ArrayList<>();
		}
		this.availableMechanisms.add(value);
		return (T) this;
	}

	/**
	 * The SASL mechanisms available from this factory after all filtering has
	 * been applied.
	 */
	@SuppressWarnings("unchecked")
	public T availableMechanisms(String... args) {
		availableMechanisms(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * List of filters to be evaluated sequentially combining the results using
	 * 'or'.
	 */
	@ModelNodeBinding(detypedName = "filters")
	public List<Map> filters() {
		return this.filters;
	}

	/**
	 * List of filters to be evaluated sequentially combining the results using
	 * 'or'.
	 */
	@SuppressWarnings("unchecked")
	public T filters(java.util.List<java.util.Map> value) {
		Object oldValue = this.filters;
		this.filters = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("filters", oldValue, value);
		return (T) this;
	}

	/**
	 * List of filters to be evaluated sequentially combining the results using
	 * 'or'.
	 */
	@SuppressWarnings("unchecked")
	public T filter(java.util.Map value) {
		if (this.filters == null) {
			this.filters = new java.util.ArrayList<>();
		}
		this.filters.add(value);
		return (T) this;
	}

	/**
	 * List of filters to be evaluated sequentially combining the results using
	 * 'or'.
	 */
	@SuppressWarnings("unchecked")
	public T filters(java.util.Map... args) {
		filters(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * Custom properties to be passed in to the sasl server factory calls.
	 */
	@ModelNodeBinding(detypedName = "properties")
	public Map properties() {
		return this.properties;
	}

	/**
	 * Custom properties to be passed in to the sasl server factory calls.
	 */
	@SuppressWarnings("unchecked")
	public T properties(java.util.Map value) {
		Object oldValue = this.properties;
		this.properties = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("properties", oldValue, value);
		return (T) this;
	}

	/**
	 * Custom properties to be passed in to the sasl server factory calls.
	 */
	@SuppressWarnings("unchecked")
	public T property(java.lang.String key, java.lang.Object value) {
		if (this.properties == null) {
			this.properties = new java.util.HashMap<>();
		}
		this.properties.put(key, value);
		return (T) this;
	}

	/**
	 * The protocol that should be passed into factory when creating the
	 * mechanism.
	 */
	@ModelNodeBinding(detypedName = "protocol")
	public String protocol() {
		return this.protocol;
	}

	/**
	 * The protocol that should be passed into factory when creating the
	 * mechanism.
	 */
	@SuppressWarnings("unchecked")
	public T protocol(java.lang.String value) {
		Object oldValue = this.protocol;
		this.protocol = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("protocol", oldValue, value);
		return (T) this;
	}

	/**
	 * The sasl server factory to be wrapped.
	 */
	@ModelNodeBinding(detypedName = "sasl-server-factory")
	public String saslServerFactory() {
		return this.saslServerFactory;
	}

	/**
	 * The sasl server factory to be wrapped.
	 */
	@SuppressWarnings("unchecked")
	public T saslServerFactory(java.lang.String value) {
		Object oldValue = this.saslServerFactory;
		this.saslServerFactory = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("saslServerFactory", oldValue, value);
		return (T) this;
	}

	/**
	 * The server name that should be passed into factory when creating the
	 * mechanism.
	 */
	@ModelNodeBinding(detypedName = "server-name")
	public String serverName() {
		return this.serverName;
	}

	/**
	 * The server name that should be passed into factory when creating the
	 * mechanism.
	 */
	@SuppressWarnings("unchecked")
	public T serverName(java.lang.String value) {
		Object oldValue = this.serverName;
		this.serverName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("serverName", oldValue, value);
		return (T) this;
	}
}