package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Map;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * Definition of a permission mapper that always returns the same constant.
 */
@Address("/subsystem=elytron/constant-permission-mapper=*")
@ResourceType("constant-permission-mapper")
public class ConstantPermissionMapper<T extends ConstantPermissionMapper<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The permission sets to assign.")
	private List<java.util.Map> permissionSets;
	@AttributeDocumentation("The permissions to assign.")
	private List<java.util.Map> permissions;

	public ConstantPermissionMapper(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The permission sets to assign.
	 */
	@ModelNodeBinding(detypedName = "permission-sets")
	public List<Map> permissionSets() {
		return this.permissionSets;
	}

	/**
	 * The permission sets to assign.
	 */
	@SuppressWarnings("unchecked")
	public T permissionSets(java.util.List<java.util.Map> value) {
		Object oldValue = this.permissionSets;
		this.permissionSets = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("permissionSets", oldValue, value);
		return (T) this;
	}

	/**
	 * The permission sets to assign.
	 */
	@SuppressWarnings("unchecked")
	public T permissionSet(java.util.Map value) {
		if (this.permissionSets == null) {
			this.permissionSets = new java.util.ArrayList<>();
		}
		this.permissionSets.add(value);
		return (T) this;
	}

	/**
	 * The permission sets to assign.
	 */
	@SuppressWarnings("unchecked")
	public T permissionSets(java.util.Map... args) {
		permissionSets(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * The permissions to assign.
	 * 
	 * @deprecated Use permission-sets instead.
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "permissions")
	public List<Map> permissions() {
		return this.permissions;
	}

	/**
	 * The permissions to assign.
	 * 
	 * @deprecated Use permission-sets instead.
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T permissions(java.util.List<java.util.Map> value) {
		Object oldValue = this.permissions;
		this.permissions = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("permissions", oldValue, value);
		return (T) this;
	}

	/**
	 * The permissions to assign.
	 * 
	 * @deprecated Use permission-sets instead.
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T permission(java.util.Map value) {
		if (this.permissions == null) {
			this.permissions = new java.util.ArrayList<>();
		}
		this.permissions.add(value);
		return (T) this;
	}

	/**
	 * The permissions to assign.
	 * 
	 * @deprecated Use permission-sets instead.
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T permissions(java.util.Map... args) {
		permissions(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}
}