package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;

/**
 * Definition of a custom evidence decoder.
 */
@Address("/subsystem=elytron/custom-evidence-decoder=*")
@ResourceType("custom-evidence-decoder")
public class CustomEvidenceDecoder<T extends CustomEvidenceDecoder<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Fully qualified class name of the evidence decoder.")
	private String className;
	@AttributeDocumentation("The optional key/value configuration for the evidence decoder.")
	private Map configuration;
	@AttributeDocumentation("Name of the module to use to load the evidence decoder.")
	private String module;

	public CustomEvidenceDecoder(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Fully qualified class name of the evidence decoder.
	 */
	@ModelNodeBinding(detypedName = "class-name")
	public String className() {
		return this.className;
	}

	/**
	 * Fully qualified class name of the evidence decoder.
	 */
	@SuppressWarnings("unchecked")
	public T className(java.lang.String value) {
		Object oldValue = this.className;
		this.className = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("className", oldValue, value);
		return (T) this;
	}

	/**
	 * The optional key/value configuration for the evidence decoder.
	 */
	@ModelNodeBinding(detypedName = "configuration")
	public Map configuration() {
		return this.configuration;
	}

	/**
	 * The optional key/value configuration for the evidence decoder.
	 */
	@SuppressWarnings("unchecked")
	public T configuration(java.util.Map value) {
		Object oldValue = this.configuration;
		this.configuration = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("configuration", oldValue, value);
		return (T) this;
	}

	/**
	 * The optional key/value configuration for the evidence decoder.
	 */
	@SuppressWarnings("unchecked")
	public T configuration(java.lang.String key, java.lang.Object value) {
		if (this.configuration == null) {
			this.configuration = new java.util.HashMap<>();
		}
		this.configuration.put(key, value);
		return (T) this;
	}

	/**
	 * Name of the module to use to load the evidence decoder.
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * Name of the module to use to load the evidence decoder.
	 */
	@SuppressWarnings("unchecked")
	public T module(java.lang.String value) {
		Object oldValue = this.module;
		this.module = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("module", oldValue, value);
		return (T) this;
	}
}