package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.CustomEvidenceDecoder;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface CustomEvidenceDecoderConsumer<T extends CustomEvidenceDecoder<T>> {

	/**
	 * Configure a pre-constructed instance of CustomEvidenceDecoder resource
	 * 
	 * @parameter Instance of CustomEvidenceDecoder to configure
	 * @return nothing
	 */
	void accept(T value);

	default CustomEvidenceDecoderConsumer<T> andThen(
			CustomEvidenceDecoderConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}