package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.CustomPermissionMapper;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface CustomPermissionMapperConsumer<T extends CustomPermissionMapper<T>> {

	/**
	 * Configure a pre-constructed instance of CustomPermissionMapper resource
	 * 
	 * @parameter Instance of CustomPermissionMapper to configure
	 * @return nothing
	 */
	void accept(T value);

	default CustomPermissionMapperConsumer<T> andThen(
			CustomPermissionMapperConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}