package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.DirContext;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface DirContextConsumer<T extends DirContext<T>> {

	/**
	 * Configure a pre-constructed instance of DirContext resource
	 * 
	 * @parameter Instance of DirContext to configure
	 * @return nothing
	 */
	void accept(T value);

	default DirContextConsumer<T> andThen(DirContextConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}