package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * Realm definition for a realm which contains a single pre-defined identity.
 */
@Address("/subsystem=elytron/identity-realm=*")
@ResourceType("identity-realm")
public class IdentityRealm<T extends IdentityRealm<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The name of the attribute associated with this identity.")
	private String attributeName;
	@AttributeDocumentation("The values associated with the identity attributes.")
	private List<String> attributeValues;
	@AttributeDocumentation("The name of the identity available from the security realm.")
	private String identity;

	public IdentityRealm(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The name of the attribute associated with this identity.
	 */
	@ModelNodeBinding(detypedName = "attribute-name")
	public String attributeName() {
		return this.attributeName;
	}

	/**
	 * The name of the attribute associated with this identity.
	 */
	@SuppressWarnings("unchecked")
	public T attributeName(java.lang.String value) {
		Object oldValue = this.attributeName;
		this.attributeName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("attributeName", oldValue, value);
		return (T) this;
	}

	/**
	 * The values associated with the identity attributes.
	 */
	@ModelNodeBinding(detypedName = "attribute-values")
	public List<String> attributeValues() {
		return this.attributeValues;
	}

	/**
	 * The values associated with the identity attributes.
	 */
	@SuppressWarnings("unchecked")
	public T attributeValues(java.util.List<String> value) {
		Object oldValue = this.attributeValues;
		this.attributeValues = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("attributeValues", oldValue, value);
		return (T) this;
	}

	/**
	 * The values associated with the identity attributes.
	 */
	@SuppressWarnings("unchecked")
	public T attributeValue(String value) {
		if (this.attributeValues == null) {
			this.attributeValues = new java.util.ArrayList<>();
		}
		this.attributeValues.add(value);
		return (T) this;
	}

	/**
	 * The values associated with the identity attributes.
	 */
	@SuppressWarnings("unchecked")
	public T attributeValues(String... args) {
		attributeValues(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * The name of the identity available from the security realm.
	 */
	@ModelNodeBinding(detypedName = "identity")
	public String identity() {
		return this.identity;
	}

	/**
	 * The name of the identity available from the security realm.
	 */
	@SuppressWarnings("unchecked")
	public T identity(java.lang.String value) {
		Object oldValue = this.identity;
		this.identity = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("identity", oldValue, value);
		return (T) this;
	}
}