package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Map;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * Resource containing the JASPI ServerAuthModule configuration for the servlet
 * profile.
 */
@Address("/subsystem=elytron/jaspi-configuration=*")
@ResourceType("jaspi-configuration")
public class JaspiConfiguration<T extends JaspiConfiguration<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The application-context this configuration is to be associated with or '*' for all application contexts.")
	private String applicationContext;
	@AttributeDocumentation("Description of this configuration.")
	private String description;
	@AttributeDocumentation("The layer this configuration is to be associated with or '*' for all layers.")
	private String layer;
	@AttributeDocumentation("List of ServerAuthModule definitions for this configuration.")
	private List<java.util.Map> serverAuthModules;

	public JaspiConfiguration(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The application-context this configuration is to be associated with or
	 * '*' for all application contexts.
	 */
	@ModelNodeBinding(detypedName = "application-context")
	public String applicationContext() {
		return this.applicationContext;
	}

	/**
	 * The application-context this configuration is to be associated with or
	 * '*' for all application contexts.
	 */
	@SuppressWarnings("unchecked")
	public T applicationContext(java.lang.String value) {
		Object oldValue = this.applicationContext;
		this.applicationContext = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("applicationContext", oldValue, value);
		return (T) this;
	}

	/**
	 * Description of this configuration.
	 */
	@ModelNodeBinding(detypedName = "description")
	public String description() {
		return this.description;
	}

	/**
	 * Description of this configuration.
	 */
	@SuppressWarnings("unchecked")
	public T description(java.lang.String value) {
		Object oldValue = this.description;
		this.description = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("description", oldValue, value);
		return (T) this;
	}

	/**
	 * The layer this configuration is to be associated with or '*' for all
	 * layers.
	 */
	@ModelNodeBinding(detypedName = "layer")
	public String layer() {
		return this.layer;
	}

	/**
	 * The layer this configuration is to be associated with or '*' for all
	 * layers.
	 */
	@SuppressWarnings("unchecked")
	public T layer(java.lang.String value) {
		Object oldValue = this.layer;
		this.layer = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("layer", oldValue, value);
		return (T) this;
	}

	/**
	 * List of ServerAuthModule definitions for this configuration.
	 */
	@ModelNodeBinding(detypedName = "server-auth-modules")
	public List<Map> serverAuthModules() {
		return this.serverAuthModules;
	}

	/**
	 * List of ServerAuthModule definitions for this configuration.
	 */
	@SuppressWarnings("unchecked")
	public T serverAuthModules(java.util.List<java.util.Map> value) {
		Object oldValue = this.serverAuthModules;
		this.serverAuthModules = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("serverAuthModules", oldValue, value);
		return (T) this;
	}

	/**
	 * List of ServerAuthModule definitions for this configuration.
	 */
	@SuppressWarnings("unchecked")
	public T serverAuthModule(java.util.Map value) {
		if (this.serverAuthModules == null) {
			this.serverAuthModules = new java.util.ArrayList<>();
		}
		this.serverAuthModules.add(value);
		return (T) this;
	}

	/**
	 * List of ServerAuthModule definitions for this configuration.
	 */
	@SuppressWarnings("unchecked")
	public T serverAuthModules(java.util.Map... args) {
		serverAuthModules(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}
}