package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.JaspiConfiguration;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface JaspiConfigurationConsumer<T extends JaspiConfiguration<T>> {

	/**
	 * Configure a pre-constructed instance of JaspiConfiguration resource
	 * 
	 * @parameter Instance of JaspiConfiguration to configure
	 * @return nothing
	 */
	void accept(T value);

	default JaspiConfigurationConsumer<T> andThen(
			JaspiConfigurationConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}