package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.Map;

/**
 * A security factory for obtaining a GSSCredential for use during
 * authentication.
 */
@Address("/subsystem=elytron/kerberos-security-factory=*")
@ResourceType("kerberos-security-factory")
public class KerberosSecurityFactory<T extends KerberosSecurityFactory<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Should the JAAS step of obtaining the credential have debug logging enabled.")
	private Boolean debug;
	@AttributeDocumentation("Amount of seconds before new try to obtain server credential should be done if it has failed last time.")
	private Integer failCache;
	@AttributeDocumentation("The mechanism names the credential should be usable with. Names will be converted to OIDs and used together with OIDs from mechanism-oids attribute.")
	private List<String> mechanismNames;
	@AttributeDocumentation("The mechanism OIDs the credential should be usable with. Will be used together with OIDs derived from names from mechanism-names attribute.")
	private List<String> mechanismOids;
	@AttributeDocumentation("How much lifetime (in seconds) should a cached credential have remaining before it is recreated.")
	private Integer minimumRemainingLifetime;
	@AttributeDocumentation("Should the KerberosTicket also be obtained and associated with the credential. This is required to be true where credentials are delegated to the server.")
	private Boolean obtainKerberosTicket;
	@AttributeDocumentation("The Krb5LoginModule additional options.")
	private Map options;
	@AttributeDocumentation("The path of the KeyTab to load to obtain the credential.")
	private String path;
	@AttributeDocumentation("The principal represented by the KeyTab")
	private String principal;
	@AttributeDocumentation("The name of another previously named path, or of one of the standard paths provided by the system. If 'relative-to' is provided, the value of the 'path' attribute is treated as relative to the path specified by this attribute.")
	private String relativeTo;
	@AttributeDocumentation("How much lifetime (in seconds) should be requested for newly created credentials.")
	private Integer requestLifetime;
	@AttributeDocumentation("Is the keytab file with adequate principal required to exist at the time the service starts?")
	private Boolean required;
	@AttributeDocumentation("If this for use server side or client side?")
	private Boolean server;
	@AttributeDocumentation("Should generated GSS credentials be wrapped to prevent improper disposal or not?")
	private Boolean wrapGssCredential;

	public KerberosSecurityFactory(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Should the JAAS step of obtaining the credential have debug logging
	 * enabled.
	 */
	@ModelNodeBinding(detypedName = "debug")
	public Boolean debug() {
		return this.debug;
	}

	/**
	 * Should the JAAS step of obtaining the credential have debug logging
	 * enabled.
	 */
	@SuppressWarnings("unchecked")
	public T debug(java.lang.Boolean value) {
		Object oldValue = this.debug;
		this.debug = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("debug", oldValue, value);
		return (T) this;
	}

	/**
	 * Amount of seconds before new try to obtain server credential should be
	 * done if it has failed last time.
	 */
	@ModelNodeBinding(detypedName = "fail-cache")
	public Integer failCache() {
		return this.failCache;
	}

	/**
	 * Amount of seconds before new try to obtain server credential should be
	 * done if it has failed last time.
	 */
	@SuppressWarnings("unchecked")
	public T failCache(java.lang.Integer value) {
		Object oldValue = this.failCache;
		this.failCache = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("failCache", oldValue, value);
		return (T) this;
	}

	/**
	 * The mechanism names the credential should be usable with. Names will be
	 * converted to OIDs and used together with OIDs from mechanism-oids
	 * attribute.
	 */
	@ModelNodeBinding(detypedName = "mechanism-names")
	public List<String> mechanismNames() {
		return this.mechanismNames;
	}

	/**
	 * The mechanism names the credential should be usable with. Names will be
	 * converted to OIDs and used together with OIDs from mechanism-oids
	 * attribute.
	 */
	@SuppressWarnings("unchecked")
	public T mechanismNames(java.util.List<String> value) {
		Object oldValue = this.mechanismNames;
		this.mechanismNames = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("mechanismNames", oldValue, value);
		return (T) this;
	}

	/**
	 * The mechanism names the credential should be usable with. Names will be
	 * converted to OIDs and used together with OIDs from mechanism-oids
	 * attribute.
	 */
	@SuppressWarnings("unchecked")
	public T mechanismName(String value) {
		if (this.mechanismNames == null) {
			this.mechanismNames = new java.util.ArrayList<>();
		}
		this.mechanismNames.add(value);
		return (T) this;
	}

	/**
	 * The mechanism names the credential should be usable with. Names will be
	 * converted to OIDs and used together with OIDs from mechanism-oids
	 * attribute.
	 */
	@SuppressWarnings("unchecked")
	public T mechanismNames(String... args) {
		mechanismNames(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * The mechanism OIDs the credential should be usable with. Will be used
	 * together with OIDs derived from names from mechanism-names attribute.
	 */
	@ModelNodeBinding(detypedName = "mechanism-oids")
	public List<String> mechanismOids() {
		return this.mechanismOids;
	}

	/**
	 * The mechanism OIDs the credential should be usable with. Will be used
	 * together with OIDs derived from names from mechanism-names attribute.
	 */
	@SuppressWarnings("unchecked")
	public T mechanismOids(java.util.List<String> value) {
		Object oldValue = this.mechanismOids;
		this.mechanismOids = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("mechanismOids", oldValue, value);
		return (T) this;
	}

	/**
	 * The mechanism OIDs the credential should be usable with. Will be used
	 * together with OIDs derived from names from mechanism-names attribute.
	 */
	@SuppressWarnings("unchecked")
	public T mechanismOid(String value) {
		if (this.mechanismOids == null) {
			this.mechanismOids = new java.util.ArrayList<>();
		}
		this.mechanismOids.add(value);
		return (T) this;
	}

	/**
	 * The mechanism OIDs the credential should be usable with. Will be used
	 * together with OIDs derived from names from mechanism-names attribute.
	 */
	@SuppressWarnings("unchecked")
	public T mechanismOids(String... args) {
		mechanismOids(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * How much lifetime (in seconds) should a cached credential have remaining
	 * before it is recreated.
	 */
	@ModelNodeBinding(detypedName = "minimum-remaining-lifetime")
	public Integer minimumRemainingLifetime() {
		return this.minimumRemainingLifetime;
	}

	/**
	 * How much lifetime (in seconds) should a cached credential have remaining
	 * before it is recreated.
	 */
	@SuppressWarnings("unchecked")
	public T minimumRemainingLifetime(java.lang.Integer value) {
		Object oldValue = this.minimumRemainingLifetime;
		this.minimumRemainingLifetime = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("minimumRemainingLifetime", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Should the KerberosTicket also be obtained and associated with the
	 * credential. This is required to be true where credentials are delegated
	 * to the server.
	 */
	@ModelNodeBinding(detypedName = "obtain-kerberos-ticket")
	public Boolean obtainKerberosTicket() {
		return this.obtainKerberosTicket;
	}

	/**
	 * Should the KerberosTicket also be obtained and associated with the
	 * credential. This is required to be true where credentials are delegated
	 * to the server.
	 */
	@SuppressWarnings("unchecked")
	public T obtainKerberosTicket(java.lang.Boolean value) {
		Object oldValue = this.obtainKerberosTicket;
		this.obtainKerberosTicket = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("obtainKerberosTicket", oldValue, value);
		return (T) this;
	}

	/**
	 * The Krb5LoginModule additional options.
	 */
	@ModelNodeBinding(detypedName = "options")
	public Map options() {
		return this.options;
	}

	/**
	 * The Krb5LoginModule additional options.
	 */
	@SuppressWarnings("unchecked")
	public T options(java.util.Map value) {
		Object oldValue = this.options;
		this.options = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("options", oldValue, value);
		return (T) this;
	}

	/**
	 * The Krb5LoginModule additional options.
	 */
	@SuppressWarnings("unchecked")
	public T option(java.lang.String key, java.lang.Object value) {
		if (this.options == null) {
			this.options = new java.util.HashMap<>();
		}
		this.options.put(key, value);
		return (T) this;
	}

	/**
	 * The path of the KeyTab to load to obtain the credential.
	 */
	@ModelNodeBinding(detypedName = "path")
	public String path() {
		return this.path;
	}

	/**
	 * The path of the KeyTab to load to obtain the credential.
	 */
	@SuppressWarnings("unchecked")
	public T path(java.lang.String value) {
		Object oldValue = this.path;
		this.path = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("path", oldValue, value);
		return (T) this;
	}

	/**
	 * The principal represented by the KeyTab
	 */
	@ModelNodeBinding(detypedName = "principal")
	public String principal() {
		return this.principal;
	}

	/**
	 * The principal represented by the KeyTab
	 */
	@SuppressWarnings("unchecked")
	public T principal(java.lang.String value) {
		Object oldValue = this.principal;
		this.principal = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("principal", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of another previously named path, or of one of the standard
	 * paths provided by the system. If 'relative-to' is provided, the value of
	 * the 'path' attribute is treated as relative to the path specified by this
	 * attribute.
	 */
	@ModelNodeBinding(detypedName = "relative-to")
	public String relativeTo() {
		return this.relativeTo;
	}

	/**
	 * The name of another previously named path, or of one of the standard
	 * paths provided by the system. If 'relative-to' is provided, the value of
	 * the 'path' attribute is treated as relative to the path specified by this
	 * attribute.
	 */
	@SuppressWarnings("unchecked")
	public T relativeTo(java.lang.String value) {
		Object oldValue = this.relativeTo;
		this.relativeTo = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("relativeTo", oldValue, value);
		return (T) this;
	}

	/**
	 * How much lifetime (in seconds) should be requested for newly created
	 * credentials.
	 */
	@ModelNodeBinding(detypedName = "request-lifetime")
	public Integer requestLifetime() {
		return this.requestLifetime;
	}

	/**
	 * How much lifetime (in seconds) should be requested for newly created
	 * credentials.
	 */
	@SuppressWarnings("unchecked")
	public T requestLifetime(java.lang.Integer value) {
		Object oldValue = this.requestLifetime;
		this.requestLifetime = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("requestLifetime", oldValue, value);
		return (T) this;
	}

	/**
	 * Is the keytab file with adequate principal required to exist at the time
	 * the service starts?
	 */
	@ModelNodeBinding(detypedName = "required")
	public Boolean required() {
		return this.required;
	}

	/**
	 * Is the keytab file with adequate principal required to exist at the time
	 * the service starts?
	 */
	@SuppressWarnings("unchecked")
	public T required(java.lang.Boolean value) {
		Object oldValue = this.required;
		this.required = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("required", oldValue, value);
		return (T) this;
	}

	/**
	 * If this for use server side or client side?
	 */
	@ModelNodeBinding(detypedName = "server")
	public Boolean server() {
		return this.server;
	}

	/**
	 * If this for use server side or client side?
	 */
	@SuppressWarnings("unchecked")
	public T server(java.lang.Boolean value) {
		Object oldValue = this.server;
		this.server = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("server", oldValue, value);
		return (T) this;
	}

	/**
	 * Should generated GSS credentials be wrapped to prevent improper disposal
	 * or not?
	 */
	@ModelNodeBinding(detypedName = "wrap-gss-credential")
	public Boolean wrapGssCredential() {
		return this.wrapGssCredential;
	}

	/**
	 * Should generated GSS credentials be wrapped to prevent improper disposal
	 * or not?
	 */
	@SuppressWarnings("unchecked")
	public T wrapGssCredential(java.lang.Boolean value) {
		Object oldValue = this.wrapGssCredential;
		this.wrapGssCredential = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("wrapGssCredential", oldValue, value);
		return (T) this;
	}
}