package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.LdapKeyStore;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface LdapKeyStoreConsumer<T extends LdapKeyStore<T>> {

	/**
	 * Configure a pre-constructed instance of LdapKeyStore resource
	 * 
	 * @parameter Instance of LdapKeyStore to configure
	 * @return nothing
	 */
	void accept(T value);

	default LdapKeyStoreConsumer<T> andThen(LdapKeyStoreConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}