package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;

/**
 * A definition that sets up a policy provider.
 */
@Address("/subsystem=elytron/policy=*")
@ResourceType("policy")
public class Policy<T extends Policy<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("A custom policy provider definition.")
	private Map customPolicy;
	@AttributeDocumentation("Not used.")
	private String defaultPolicy;
	@AttributeDocumentation("A policy provider definition that sets up JACC and related services.")
	private Map jaccPolicy;

	public Policy(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * A custom policy provider definition.
	 */
	@ModelNodeBinding(detypedName = "custom-policy")
	public Map customPolicy() {
		return this.customPolicy;
	}

	/**
	 * A custom policy provider definition.
	 */
	@SuppressWarnings("unchecked")
	public T customPolicy(java.util.Map value) {
		Object oldValue = this.customPolicy;
		this.customPolicy = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("customPolicy", oldValue, value);
		return (T) this;
	}

	/**
	 * A custom policy provider definition.
	 */
	@SuppressWarnings("unchecked")
	public T customPolicy(java.lang.String key, java.lang.Object value) {
		if (this.customPolicy == null) {
			this.customPolicy = new java.util.HashMap<>();
		}
		this.customPolicy.put(key, value);
		return (T) this;
	}

	/**
	 * Not used.
	 * 
	 * @deprecated The 'default-policy' attribute is ignored, as a policy
	 *             resource should be configured with only one policy.
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "default-policy")
	public String defaultPolicy() {
		return this.defaultPolicy;
	}

	/**
	 * Not used.
	 * 
	 * @deprecated The 'default-policy' attribute is ignored, as a policy
	 *             resource should be configured with only one policy.
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T defaultPolicy(java.lang.String value) {
		Object oldValue = this.defaultPolicy;
		this.defaultPolicy = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultPolicy", oldValue, value);
		return (T) this;
	}

	/**
	 * A policy provider definition that sets up JACC and related services.
	 */
	@ModelNodeBinding(detypedName = "jacc-policy")
	public Map jaccPolicy() {
		return this.jaccPolicy;
	}

	/**
	 * A policy provider definition that sets up JACC and related services.
	 */
	@SuppressWarnings("unchecked")
	public T jaccPolicy(java.util.Map value) {
		Object oldValue = this.jaccPolicy;
		this.jaccPolicy = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("jaccPolicy", oldValue, value);
		return (T) this;
	}

	/**
	 * A policy provider definition that sets up JACC and related services.
	 */
	@SuppressWarnings("unchecked")
	public T jaccPolicy(java.lang.String key, java.lang.Object value) {
		if (this.jaccPolicy == null) {
			this.jaccPolicy = new java.util.HashMap<>();
		}
		this.jaccPolicy.put(key, value);
		return (T) this;
	}
}