package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.ProviderHTTPServerMechanismFactory;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ProviderHTTPServerMechanismFactoryConsumer<T extends ProviderHTTPServerMechanismFactory<T>> {

	/**
	 * Configure a pre-constructed instance of
	 * ProviderHTTPServerMechanismFactory resource
	 * 
	 * @parameter Instance of ProviderHTTPServerMechanismFactory to configure
	 * @return nothing
	 */
	void accept(T value);

	default ProviderHTTPServerMechanismFactoryConsumer<T> andThen(
			ProviderHTTPServerMechanismFactoryConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}