package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.ProviderLoader;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ProviderLoaderConsumer<T extends ProviderLoader<T>> {

	/**
	 * Configure a pre-constructed instance of ProviderLoader resource
	 * 
	 * @parameter Instance of ProviderLoader to configure
	 * @return nothing
	 */
	void accept(T value);

	default ProviderLoaderConsumer<T> andThen(ProviderLoaderConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}