package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.ServerSslContext;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ServerSslContextConsumer<T extends ServerSslContext<T>> {

	/**
	 * Configure a pre-constructed instance of ServerSslContext resource
	 * 
	 * @parameter Instance of ServerSslContext to configure
	 * @return nothing
	 */
	void accept(T value);

	default ServerSslContextConsumer<T> andThen(
			ServerSslContextConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}