package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;

/**
 * A server side SNI Aware SSLContext that selects between an underlying context
 * based on the provided SNI name
 */
@Address("/subsystem=elytron/server-ssl-sni-context=*")
@ResourceType("server-ssl-sni-context")
public class ServerSslSniContext<T extends ServerSslSniContext<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The context to use if no SNI information is present, or if it does not match any mappings")
	private String defaultSslContext;
	@AttributeDocumentation("A mapping between a server name and an SSContext")
	private Map hostContextMap;

	public ServerSslSniContext(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The context to use if no SNI information is present, or if it does not
	 * match any mappings
	 */
	@ModelNodeBinding(detypedName = "default-ssl-context")
	public String defaultSslContext() {
		return this.defaultSslContext;
	}

	/**
	 * The context to use if no SNI information is present, or if it does not
	 * match any mappings
	 */
	@SuppressWarnings("unchecked")
	public T defaultSslContext(java.lang.String value) {
		Object oldValue = this.defaultSslContext;
		this.defaultSslContext = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultSslContext", oldValue, value);
		return (T) this;
	}

	/**
	 * A mapping between a server name and an SSContext
	 */
	@ModelNodeBinding(detypedName = "host-context-map")
	public Map hostContextMap() {
		return this.hostContextMap;
	}

	/**
	 * A mapping between a server name and an SSContext
	 */
	@SuppressWarnings("unchecked")
	public T hostContextMap(java.util.Map value) {
		Object oldValue = this.hostContextMap;
		this.hostContextMap = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("hostContextMap", oldValue, value);
		return (T) this;
	}

	/**
	 * A mapping between a server name and an SSContext
	 */
	@SuppressWarnings("unchecked")
	public T hostContextMap(java.lang.String key, java.lang.Object value) {
		if (this.hostContextMap == null) {
			this.hostContextMap = new java.util.HashMap<>();
		}
		this.hostContextMap.put(key, value);
		return (T) this;
	}
}