package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * Definition of a simple configured permission mapper.
 */
@Address("/subsystem=elytron/simple-permission-mapper=*")
@ResourceType("simple-permission-mapper")
public class SimplePermissionMapper<T extends SimplePermissionMapper<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The mapping mode that should be used in the event of multiple matches.")
	private MappingMode mappingMode;
	@AttributeDocumentation("The defined permission mappings.")
	private List<java.util.Map> permissionMappings;

	public SimplePermissionMapper(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public static enum MappingMode {
		AND("and"), OR("or"), XOR("xor"), UNLESS("unless"), FIRST("first");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		MappingMode(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	/**
	 * The mapping mode that should be used in the event of multiple matches.
	 */
	@ModelNodeBinding(detypedName = "mapping-mode")
	public MappingMode mappingMode() {
		return this.mappingMode;
	}

	/**
	 * The mapping mode that should be used in the event of multiple matches.
	 */
	@SuppressWarnings("unchecked")
	public T mappingMode(MappingMode value) {
		Object oldValue = this.mappingMode;
		this.mappingMode = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("mappingMode", oldValue, value);
		return (T) this;
	}

	/**
	 * The defined permission mappings.
	 */
	@ModelNodeBinding(detypedName = "permission-mappings")
	public List<Map> permissionMappings() {
		return this.permissionMappings;
	}

	/**
	 * The defined permission mappings.
	 */
	@SuppressWarnings("unchecked")
	public T permissionMappings(java.util.List<java.util.Map> value) {
		Object oldValue = this.permissionMappings;
		this.permissionMappings = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("permissionMappings", oldValue, value);
		return (T) this;
	}

	/**
	 * The defined permission mappings.
	 */
	@SuppressWarnings("unchecked")
	public T permissionMapping(java.util.Map value) {
		if (this.permissionMappings == null) {
			this.permissionMappings = new java.util.ArrayList<>();
		}
		this.permissionMappings.add(value);
		return (T) this;
	}

	/**
	 * The defined permission mappings.
	 */
	@SuppressWarnings("unchecked")
	public T permissionMappings(java.util.Map... args) {
		permissionMappings(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}
}