package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;
import org.wildfly.swarm.config.elytron.Format;

/**
 * An audit logger that sends audit events to a remote syslog server.
 */
@Address("/subsystem=elytron/syslog-audit-log=*")
@ResourceType("syslog-audit-log")
public class SyslogAuditLog<T extends SyslogAuditLog<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The format to use to record the audit event.")
	private Format format;
	@AttributeDocumentation("The host name to embed withing all events sent to the remote syslog server.")
	private String hostName;
	@AttributeDocumentation("The listening port on the syslog server.")
	private Integer port;
	@AttributeDocumentation("The maximum amount of failed reconnect attempts that should be made for sending messages to a syslog server before the endpoint is closed.")
	private Integer reconnectAttempts;
	@AttributeDocumentation("The server address of the syslog server the events should be sent to.")
	private String serverAddress;
	@AttributeDocumentation("The SSLContext to use to connect to the syslog server when SSL_TCP transport is used.")
	private String sslContext;
	@AttributeDocumentation("The RFC format to be used for describing the audit event.")
	private SyslogFormat syslogFormat;
	@AttributeDocumentation("The transport to use to connect to the syslog server.")
	private Transport transport;

	public SyslogAuditLog(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public static enum SyslogFormat {
		RFC3164("RFC3164"), RFC5424("RFC5424");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		SyslogFormat(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	public static enum Transport {
		TCP("TCP"), UDP("UDP"), SSL_TCP("SSL_TCP");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		Transport(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	/**
	 * The format to use to record the audit event.
	 */
	@ModelNodeBinding(detypedName = "format")
	public Format format() {
		return this.format;
	}

	/**
	 * The format to use to record the audit event.
	 */
	@SuppressWarnings("unchecked")
	public T format(Format value) {
		Object oldValue = this.format;
		this.format = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("format", oldValue, value);
		return (T) this;
	}

	/**
	 * The host name to embed withing all events sent to the remote syslog
	 * server.
	 */
	@ModelNodeBinding(detypedName = "host-name")
	public String hostName() {
		return this.hostName;
	}

	/**
	 * The host name to embed withing all events sent to the remote syslog
	 * server.
	 */
	@SuppressWarnings("unchecked")
	public T hostName(java.lang.String value) {
		Object oldValue = this.hostName;
		this.hostName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("hostName", oldValue, value);
		return (T) this;
	}

	/**
	 * The listening port on the syslog server.
	 */
	@ModelNodeBinding(detypedName = "port")
	public Integer port() {
		return this.port;
	}

	/**
	 * The listening port on the syslog server.
	 */
	@SuppressWarnings("unchecked")
	public T port(java.lang.Integer value) {
		Object oldValue = this.port;
		this.port = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("port", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum amount of failed reconnect attempts that should be made for
	 * sending messages to a syslog server before the endpoint is closed.
	 */
	@ModelNodeBinding(detypedName = "reconnect-attempts")
	public Integer reconnectAttempts() {
		return this.reconnectAttempts;
	}

	/**
	 * The maximum amount of failed reconnect attempts that should be made for
	 * sending messages to a syslog server before the endpoint is closed.
	 */
	@SuppressWarnings("unchecked")
	public T reconnectAttempts(java.lang.Integer value) {
		Object oldValue = this.reconnectAttempts;
		this.reconnectAttempts = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("reconnectAttempts", oldValue, value);
		return (T) this;
	}

	/**
	 * The server address of the syslog server the events should be sent to.
	 */
	@ModelNodeBinding(detypedName = "server-address")
	public String serverAddress() {
		return this.serverAddress;
	}

	/**
	 * The server address of the syslog server the events should be sent to.
	 */
	@SuppressWarnings("unchecked")
	public T serverAddress(java.lang.String value) {
		Object oldValue = this.serverAddress;
		this.serverAddress = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("serverAddress", oldValue, value);
		return (T) this;
	}

	/**
	 * The SSLContext to use to connect to the syslog server when SSL_TCP
	 * transport is used.
	 */
	@ModelNodeBinding(detypedName = "ssl-context")
	public String sslContext() {
		return this.sslContext;
	}

	/**
	 * The SSLContext to use to connect to the syslog server when SSL_TCP
	 * transport is used.
	 */
	@SuppressWarnings("unchecked")
	public T sslContext(java.lang.String value) {
		Object oldValue = this.sslContext;
		this.sslContext = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("sslContext", oldValue, value);
		return (T) this;
	}

	/**
	 * The RFC format to be used for describing the audit event.
	 */
	@ModelNodeBinding(detypedName = "syslog-format")
	public SyslogFormat syslogFormat() {
		return this.syslogFormat;
	}

	/**
	 * The RFC format to be used for describing the audit event.
	 */
	@SuppressWarnings("unchecked")
	public T syslogFormat(SyslogFormat value) {
		Object oldValue = this.syslogFormat;
		this.syslogFormat = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("syslogFormat", oldValue, value);
		return (T) this;
	}

	/**
	 * The transport to use to connect to the syslog server.
	 */
	@ModelNodeBinding(detypedName = "transport")
	public Transport transport() {
		return this.transport;
	}

	/**
	 * The transport to use to connect to the syslog server.
	 */
	@SuppressWarnings("unchecked")
	public T transport(Transport value) {
		Object oldValue = this.transport;
		this.transport = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("transport", oldValue, value);
		return (T) this;
	}
}