package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.X500SubjectEvidenceDecoder;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface X500SubjectEvidenceDecoderConsumer<T extends X500SubjectEvidenceDecoder<T>> {

	/**
	 * Configure a pre-constructed instance of X500SubjectEvidenceDecoder
	 * resource
	 * 
	 * @parameter Instance of X500SubjectEvidenceDecoder to configure
	 * @return nothing
	 */
	void accept(T value);

	default X500SubjectEvidenceDecoderConsumer<T> andThen(
			X500SubjectEvidenceDecoderConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}