package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;

/**
 * An evidence decoder that derives the principal associated with the given
 * evidence from an X.509 subject alternative name from the first certificate in
 * the given evidence.
 */
@Address("/subsystem=elytron/x509-subject-alt-name-evidence-decoder=*")
@ResourceType("x509-subject-alt-name-evidence-decoder")
public class X509SubjectAltNameEvidenceDecoder<T extends X509SubjectAltNameEvidenceDecoder<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The subject alternative name type to decode from the given evidence. Allowed values: 'rfc822Name', 'dNSName', 'directoryName', 'uniformResourceIdentifier', 'iPAddress', 'registeredID'")
	private AltNameType altNameType;
	@AttributeDocumentation("The 0-based occurrence of the subject alternative name to map. This attribute is optional and only used when there is more than one subject alternative name of the given alt-name-type. The default value is 0.")
	private Integer segment;

	public X509SubjectAltNameEvidenceDecoder(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public static enum AltNameType {
		RFC822NAME("rfc822Name"), DNSNAME("dNSName"), DIRECTORYNAME(
				"directoryName"), UNIFORMRESOURCEIDENTIFIER(
				"uniformResourceIdentifier"), IPADDRESS("iPAddress"), REGISTEREDID(
				"registeredID");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		AltNameType(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	/**
	 * The subject alternative name type to decode from the given evidence.
	 * Allowed values: 'rfc822Name', 'dNSName', 'directoryName',
	 * 'uniformResourceIdentifier', 'iPAddress', 'registeredID'
	 */
	@ModelNodeBinding(detypedName = "alt-name-type")
	public AltNameType altNameType() {
		return this.altNameType;
	}

	/**
	 * The subject alternative name type to decode from the given evidence.
	 * Allowed values: 'rfc822Name', 'dNSName', 'directoryName',
	 * 'uniformResourceIdentifier', 'iPAddress', 'registeredID'
	 */
	@SuppressWarnings("unchecked")
	public T altNameType(AltNameType value) {
		Object oldValue = this.altNameType;
		this.altNameType = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("altNameType", oldValue, value);
		return (T) this;
	}

	/**
	 * The 0-based occurrence of the subject alternative name to map. This
	 * attribute is optional and only used when there is more than one subject
	 * alternative name of the given alt-name-type. The default value is 0.
	 */
	@ModelNodeBinding(detypedName = "segment")
	public Integer segment() {
		return this.segment;
	}

	/**
	 * The 0-based occurrence of the subject alternative name to map. This
	 * attribute is optional and only used when there is more than one subject
	 * alternative name of the given alt-name-type. The default value is 0.
	 */
	@SuppressWarnings("unchecked")
	public T segment(java.lang.Integer value) {
		Object oldValue = this.segment;
		this.segment = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("segment", oldValue, value);
		return (T) this;
	}
}