package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.X509SubjectAltNameEvidenceDecoder;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface X509SubjectAltNameEvidenceDecoderConsumer<T extends X509SubjectAltNameEvidenceDecoder<T>> {

	/**
	 * Configure a pre-constructed instance of X509SubjectAltNameEvidenceDecoder
	 * resource
	 * 
	 * @parameter Instance of X509SubjectAltNameEvidenceDecoder to configure
	 * @return nothing
	 */
	void accept(T value);

	default X509SubjectAltNameEvidenceDecoderConsumer<T> andThen(
			X509SubjectAltNameEvidenceDecoderConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}