package org.wildfly.swarm.config.infinispan;
public enum ConsistentHashStrategy {
	INTER_CACHE("INTER_CACHE"), INTRA_CACHE("INTRA_CACHE");

	private final String allowedValue;

	/**
	 * Returns the allowed value for the management model.
	 * 
	 * @return the allowed model value
	 */
	public String getAllowedValue() {
		return allowedValue;
	}

	ConsistentHashStrategy(java.lang.String allowedValue) {
		this.allowedValue = allowedValue;
	}

	@Override
	public String toString() {
		return allowedValue;
	}
}