package org.wildfly.swarm.config.infinispan;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.infinispan.remote_cache_container.RemoteCacheConsumer;
import org.wildfly.swarm.config.infinispan.remote_cache_container.RemoteCacheSupplier;
import org.wildfly.swarm.config.infinispan.remote_cache_container.RemoteCache;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.infinispan.remote_cache_container.RemoteClusterConsumer;
import org.wildfly.swarm.config.infinispan.remote_cache_container.RemoteClusterSupplier;
import org.wildfly.swarm.config.infinispan.remote_cache_container.RemoteCluster;
import org.wildfly.swarm.config.infinispan.remote_cache_container.SecurityComponent;
import org.wildfly.swarm.config.infinispan.remote_cache_container.SecurityComponentConsumer;
import org.wildfly.swarm.config.infinispan.remote_cache_container.SecurityComponentSupplier;
import org.wildfly.swarm.config.infinispan.remote_cache_container.TransactionComponent;
import org.wildfly.swarm.config.infinispan.remote_cache_container.TransactionComponentConsumer;
import org.wildfly.swarm.config.infinispan.remote_cache_container.TransactionComponentSupplier;
import org.wildfly.swarm.config.infinispan.remote_cache_container.AsyncThreadPool;
import org.wildfly.swarm.config.infinispan.remote_cache_container.AsyncThreadPoolConsumer;
import org.wildfly.swarm.config.infinispan.remote_cache_container.AsyncThreadPoolSupplier;
import org.wildfly.swarm.config.infinispan.remote_cache_container.ConnectionPoolComponent;
import org.wildfly.swarm.config.infinispan.remote_cache_container.ConnectionPoolComponentConsumer;
import org.wildfly.swarm.config.infinispan.remote_cache_container.ConnectionPoolComponentSupplier;
import org.wildfly.swarm.config.infinispan.remote_cache_container.NoneNearCache;
import org.wildfly.swarm.config.infinispan.remote_cache_container.NoneNearCacheConsumer;
import org.wildfly.swarm.config.infinispan.remote_cache_container.NoneNearCacheSupplier;
import org.wildfly.swarm.config.infinispan.remote_cache_container.InvalidationNearCache;
import org.wildfly.swarm.config.infinispan.remote_cache_container.InvalidationNearCacheConsumer;
import org.wildfly.swarm.config.infinispan.remote_cache_container.InvalidationNearCacheSupplier;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;

/**
 * The configuration of a remote Infinispan cache container.
 */
@Address("/subsystem=infinispan/remote-cache-container=*")
@ResourceType("remote-cache-container")
public class RemoteCacheContainer<T extends RemoteCacheContainer<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private RemoteCacheContainerResources subresources = new RemoteCacheContainerResources();
	@AttributeDocumentation("The number of active connections to the Infinispan server.")
	private Integer activeConnections;
	@AttributeDocumentation("Defines the maximum socket connect timeout before giving up connecting to the server.")
	private Integer connectionTimeout;
	@AttributeDocumentation("The total number of connections to the Infinispan server.")
	private Integer connections;
	@AttributeDocumentation("Required default remote server cluster.")
	private String defaultRemoteCluster;
	@AttributeDocumentation("The number of idle connections to the Infinispan server.")
	private Integer idleConnections;
	@AttributeDocumentation("This hint allows sizing of byte buffers when serializing and deserializing keys, to minimize array resizing.")
	private Integer keySizeEstimate;
	@AttributeDocumentation("Sets the maximum number of retries for each request. A valid value should be greater or equals than 0. Zero means no retry will made in case of a network failure.")
	private Integer maxRetries;
	@AttributeDocumentation("Defines the module whose class loader should be used when configuring remote cache container marshaller.")
	private String module;
	@AttributeDocumentation("This property defines the protocol version that this client should use.")
	private ProtocolVersion protocolVersion;
	@AttributeDocumentation("Enable or disable SO_TIMEOUT on socket connections to remote Hot Rod servers with the specified timeout, in milliseconds. A timeout of 0 is interpreted as an infinite timeout.")
	private Integer socketTimeout;
	@AttributeDocumentation("Enables statistics gathering for this remote cache.")
	private Boolean statisticsEnabled;
	@AttributeDocumentation("Configures TCP Keepalive on the TCP stack.")
	private Boolean tcpKeepAlive;
	@AttributeDocumentation("Enable or disable TCP_NODELAY on socket connections to remote Hot Rod servers.")
	private Boolean tcpNoDelay;
	@AttributeDocumentation("This hint allows sizing of byte buffers when serializing and deserializing values, to minimize array resizing.")
	private Integer valueSizeEstimate;

	public RemoteCacheContainer(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public RemoteCacheContainerResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all RemoteCache objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of RemoteCache objects.
	 */
	@SuppressWarnings("unchecked")
	public T remoteCaches(java.util.List<RemoteCache> value) {
		this.subresources.remoteCaches = value;
		return (T) this;
	}

	/**
	 * Add the RemoteCache object to the list of subresources
	 * 
	 * @param value
	 *            The RemoteCache to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteCache(RemoteCache value) {
		this.subresources.remoteCaches.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a RemoteCache object to the list of subresources
	 * 
	 * @param key
	 *            The key for the RemoteCache resource
	 * @param config
	 *            The RemoteCacheConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteCache(java.lang.String childKey, RemoteCacheConsumer consumer) {
		RemoteCache<? extends RemoteCache> child = new RemoteCache<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		remoteCache(child);
		return (T) this;
	}

	/**
	 * Create and configure a RemoteCache object to the list of subresources
	 * 
	 * @param key
	 *            The key for the RemoteCache resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteCache(java.lang.String childKey) {
		remoteCache(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied RemoteCache object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T remoteCache(RemoteCacheSupplier supplier) {
		remoteCache(supplier.get());
		return (T) this;
	}

	/**
	 * Add all RemoteCluster objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of RemoteCluster objects.
	 */
	@SuppressWarnings("unchecked")
	public T remoteClusters(java.util.List<RemoteCluster> value) {
		this.subresources.remoteClusters = value;
		return (T) this;
	}

	/**
	 * Add the RemoteCluster object to the list of subresources
	 * 
	 * @param value
	 *            The RemoteCluster to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteCluster(RemoteCluster value) {
		this.subresources.remoteClusters.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a RemoteCluster object to the list of subresources
	 * 
	 * @param key
	 *            The key for the RemoteCluster resource
	 * @param config
	 *            The RemoteClusterConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteCluster(java.lang.String childKey,
			RemoteClusterConsumer consumer) {
		RemoteCluster<? extends RemoteCluster> child = new RemoteCluster<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		remoteCluster(child);
		return (T) this;
	}

	/**
	 * Create and configure a RemoteCluster object to the list of subresources
	 * 
	 * @param key
	 *            The key for the RemoteCluster resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T remoteCluster(java.lang.String childKey) {
		remoteCluster(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied RemoteCluster object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T remoteCluster(RemoteClusterSupplier supplier) {
		remoteCluster(supplier.get());
		return (T) this;
	}

	/**
	 * Security configuration.
	 */
	@SuppressWarnings("unchecked")
	public T securityComponent(SecurityComponent value) {
		this.subresources.securityComponent = value;
		return (T) this;
	}

	/**
	 * Security configuration.
	 */
	@SuppressWarnings("unchecked")
	public T securityComponent(SecurityComponentConsumer consumer) {
		SecurityComponent<? extends SecurityComponent> child = new SecurityComponent<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.securityComponent = child;
		return (T) this;
	}

	/**
	 * Security configuration.
	 */
	@SuppressWarnings("unchecked")
	public T securityComponent() {
		SecurityComponent<? extends SecurityComponent> child = new SecurityComponent<>();
		this.subresources.securityComponent = child;
		return (T) this;
	}

	/**
	 * Security configuration.
	 */
	@SuppressWarnings("unchecked")
	public T securityComponent(SecurityComponentSupplier supplier) {
		this.subresources.securityComponent = supplier.get();
		return (T) this;
	}

	/**
	 * The cache transaction configuration.
	 */
	@SuppressWarnings("unchecked")
	public T transactionComponent(TransactionComponent value) {
		this.subresources.transactionComponent = value;
		return (T) this;
	}

	/**
	 * The cache transaction configuration.
	 */
	@SuppressWarnings("unchecked")
	public T transactionComponent(TransactionComponentConsumer consumer) {
		TransactionComponent<? extends TransactionComponent> child = new TransactionComponent<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.transactionComponent = child;
		return (T) this;
	}

	/**
	 * The cache transaction configuration.
	 */
	@SuppressWarnings("unchecked")
	public T transactionComponent() {
		TransactionComponent<? extends TransactionComponent> child = new TransactionComponent<>();
		this.subresources.transactionComponent = child;
		return (T) this;
	}

	/**
	 * The cache transaction configuration.
	 */
	@SuppressWarnings("unchecked")
	public T transactionComponent(TransactionComponentSupplier supplier) {
		this.subresources.transactionComponent = supplier.get();
		return (T) this;
	}

	/**
	 * Defines a thread pool used for asynchronous operations.
	 */
	@SuppressWarnings("unchecked")
	public T asyncThreadPool(AsyncThreadPool value) {
		this.subresources.asyncThreadPool = value;
		return (T) this;
	}

	/**
	 * Defines a thread pool used for asynchronous operations.
	 */
	@SuppressWarnings("unchecked")
	public T asyncThreadPool(AsyncThreadPoolConsumer consumer) {
		AsyncThreadPool<? extends AsyncThreadPool> child = new AsyncThreadPool<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.asyncThreadPool = child;
		return (T) this;
	}

	/**
	 * Defines a thread pool used for asynchronous operations.
	 */
	@SuppressWarnings("unchecked")
	public T asyncThreadPool() {
		AsyncThreadPool<? extends AsyncThreadPool> child = new AsyncThreadPool<>();
		this.subresources.asyncThreadPool = child;
		return (T) this;
	}

	/**
	 * Defines a thread pool used for asynchronous operations.
	 */
	@SuppressWarnings("unchecked")
	public T asyncThreadPool(AsyncThreadPoolSupplier supplier) {
		this.subresources.asyncThreadPool = supplier.get();
		return (T) this;
	}

	/**
	 * Configuration of the connection pool.
	 */
	@SuppressWarnings("unchecked")
	public T connectionPoolComponent(ConnectionPoolComponent value) {
		this.subresources.connectionPoolComponent = value;
		return (T) this;
	}

	/**
	 * Configuration of the connection pool.
	 */
	@SuppressWarnings("unchecked")
	public T connectionPoolComponent(ConnectionPoolComponentConsumer consumer) {
		ConnectionPoolComponent<? extends ConnectionPoolComponent> child = new ConnectionPoolComponent<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.connectionPoolComponent = child;
		return (T) this;
	}

	/**
	 * Configuration of the connection pool.
	 */
	@SuppressWarnings("unchecked")
	public T connectionPoolComponent() {
		ConnectionPoolComponent<? extends ConnectionPoolComponent> child = new ConnectionPoolComponent<>();
		this.subresources.connectionPoolComponent = child;
		return (T) this;
	}

	/**
	 * Configuration of the connection pool.
	 */
	@SuppressWarnings("unchecked")
	public T connectionPoolComponent(ConnectionPoolComponentSupplier supplier) {
		this.subresources.connectionPoolComponent = supplier.get();
		return (T) this;
	}

	/**
	 * Disables near cache.
	 */
	@SuppressWarnings("unchecked")
	public T noneNearCache(NoneNearCache value) {
		this.subresources.noneNearCache = value;
		return (T) this;
	}

	/**
	 * Disables near cache.
	 */
	@SuppressWarnings("unchecked")
	public T noneNearCache(NoneNearCacheConsumer consumer) {
		NoneNearCache<? extends NoneNearCache> child = new NoneNearCache<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.noneNearCache = child;
		return (T) this;
	}

	/**
	 * Disables near cache.
	 */
	@SuppressWarnings("unchecked")
	public T noneNearCache() {
		NoneNearCache<? extends NoneNearCache> child = new NoneNearCache<>();
		this.subresources.noneNearCache = child;
		return (T) this;
	}

	/**
	 * Disables near cache.
	 */
	@SuppressWarnings("unchecked")
	public T noneNearCache(NoneNearCacheSupplier supplier) {
		this.subresources.noneNearCache = supplier.get();
		return (T) this;
	}

	/**
	 * Configures using near cache in invalidated mode. When entries are updated
	 * or removed server-side, invalidation messages will be sent to clients to
	 * remove them from the near cache.
	 */
	@SuppressWarnings("unchecked")
	public T invalidationNearCache(InvalidationNearCache value) {
		this.subresources.invalidationNearCache = value;
		return (T) this;
	}

	/**
	 * Configures using near cache in invalidated mode. When entries are updated
	 * or removed server-side, invalidation messages will be sent to clients to
	 * remove them from the near cache.
	 */
	@SuppressWarnings("unchecked")
	public T invalidationNearCache(InvalidationNearCacheConsumer consumer) {
		InvalidationNearCache<? extends InvalidationNearCache> child = new InvalidationNearCache<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.invalidationNearCache = child;
		return (T) this;
	}

	/**
	 * Configures using near cache in invalidated mode. When entries are updated
	 * or removed server-side, invalidation messages will be sent to clients to
	 * remove them from the near cache.
	 */
	@SuppressWarnings("unchecked")
	public T invalidationNearCache() {
		InvalidationNearCache<? extends InvalidationNearCache> child = new InvalidationNearCache<>();
		this.subresources.invalidationNearCache = child;
		return (T) this;
	}

	/**
	 * Configures using near cache in invalidated mode. When entries are updated
	 * or removed server-side, invalidation messages will be sent to clients to
	 * remove them from the near cache.
	 */
	@SuppressWarnings("unchecked")
	public T invalidationNearCache(InvalidationNearCacheSupplier supplier) {
		this.subresources.invalidationNearCache = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for RemoteCacheContainer
	 */
	public static class RemoteCacheContainerResources {
		/**
		 * The configuration of the infinispan subsystem.
		 */
		@ResourceDocumentation("The configuration of the infinispan subsystem.")
		@SubresourceInfo("remoteCache")
		private List<RemoteCache> remoteCaches = new java.util.ArrayList<>();
		/**
		 * Configuration of a remote cluster.
		 */
		@ResourceDocumentation("Configuration of a remote cluster.")
		@SubresourceInfo("remoteCluster")
		private List<RemoteCluster> remoteClusters = new java.util.ArrayList<>();
		@SingletonResource
		@ResourceDocumentation("Security configuration.")
		private SecurityComponent securityComponent;
		@SingletonResource
		@ResourceDocumentation("The cache transaction configuration.")
		private TransactionComponent transactionComponent;
		@SingletonResource
		@ResourceDocumentation("Defines a thread pool used for asynchronous operations.")
		private AsyncThreadPool asyncThreadPool;
		@SingletonResource
		@ResourceDocumentation("Configuration of the connection pool.")
		private ConnectionPoolComponent connectionPoolComponent;
		@SingletonResource
		@ResourceDocumentation("Disables near cache.")
		private NoneNearCache noneNearCache;
		@SingletonResource
		@ResourceDocumentation("Configures using near cache in invalidated mode. When entries are updated or removed server-side, invalidation messages will be sent to clients to remove them from the near cache.")
		private InvalidationNearCache invalidationNearCache;

		/**
		 * Get the list of RemoteCache resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<RemoteCache> remoteCaches() {
			return this.remoteCaches;
		}

		public RemoteCache remoteCache(java.lang.String key) {
			return this.remoteCaches.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of RemoteCluster resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<RemoteCluster> remoteClusters() {
			return this.remoteClusters;
		}

		public RemoteCluster remoteCluster(java.lang.String key) {
			return this.remoteClusters.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Security configuration.
		 */
		@Subresource
		public SecurityComponent securityComponent() {
			return this.securityComponent;
		}

		/**
		 * The cache transaction configuration.
		 */
		@Subresource
		public TransactionComponent transactionComponent() {
			return this.transactionComponent;
		}

		/**
		 * Defines a thread pool used for asynchronous operations.
		 */
		@Subresource
		public AsyncThreadPool asyncThreadPool() {
			return this.asyncThreadPool;
		}

		/**
		 * Configuration of the connection pool.
		 */
		@Subresource
		public ConnectionPoolComponent connectionPoolComponent() {
			return this.connectionPoolComponent;
		}

		/**
		 * Disables near cache.
		 */
		@Subresource
		public NoneNearCache noneNearCache() {
			return this.noneNearCache;
		}

		/**
		 * Configures using near cache in invalidated mode. When entries are
		 * updated or removed server-side, invalidation messages will be sent to
		 * clients to remove them from the near cache.
		 */
		@Subresource
		public InvalidationNearCache invalidationNearCache() {
			return this.invalidationNearCache;
		}
	}

	public static enum ProtocolVersion {
		ONE_0("1.0"), ONE_1("1.1"), ONE_2("1.2"), ONE_3("1.3"), TWO_0("2.0"), TWO_1(
				"2.1"), TWO_2("2.2"), TWO_3("2.3"), TWO_4("2.4"), TWO_5("2.5"), TWO_6(
				"2.6"), TWO_7("2.7"), TWO_8("2.8"), TWO_9("2.9");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		ProtocolVersion(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	/**
	 * The number of active connections to the Infinispan server.
	 */
	@ModelNodeBinding(detypedName = "active-connections")
	public Integer activeConnections() {
		return this.activeConnections;
	}

	/**
	 * The number of active connections to the Infinispan server.
	 */
	@SuppressWarnings("unchecked")
	public T activeConnections(java.lang.Integer value) {
		Object oldValue = this.activeConnections;
		this.activeConnections = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("activeConnections", oldValue, value);
		return (T) this;
	}

	/**
	 * Defines the maximum socket connect timeout before giving up connecting to
	 * the server.
	 */
	@ModelNodeBinding(detypedName = "connection-timeout")
	public Integer connectionTimeout() {
		return this.connectionTimeout;
	}

	/**
	 * Defines the maximum socket connect timeout before giving up connecting to
	 * the server.
	 */
	@SuppressWarnings("unchecked")
	public T connectionTimeout(java.lang.Integer value) {
		Object oldValue = this.connectionTimeout;
		this.connectionTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("connectionTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * The total number of connections to the Infinispan server.
	 */
	@ModelNodeBinding(detypedName = "connections")
	public Integer connections() {
		return this.connections;
	}

	/**
	 * The total number of connections to the Infinispan server.
	 */
	@SuppressWarnings("unchecked")
	public T connections(java.lang.Integer value) {
		Object oldValue = this.connections;
		this.connections = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("connections", oldValue, value);
		return (T) this;
	}

	/**
	 * Required default remote server cluster.
	 */
	@ModelNodeBinding(detypedName = "default-remote-cluster")
	public String defaultRemoteCluster() {
		return this.defaultRemoteCluster;
	}

	/**
	 * Required default remote server cluster.
	 */
	@SuppressWarnings("unchecked")
	public T defaultRemoteCluster(java.lang.String value) {
		Object oldValue = this.defaultRemoteCluster;
		this.defaultRemoteCluster = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultRemoteCluster", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of idle connections to the Infinispan server.
	 */
	@ModelNodeBinding(detypedName = "idle-connections")
	public Integer idleConnections() {
		return this.idleConnections;
	}

	/**
	 * The number of idle connections to the Infinispan server.
	 */
	@SuppressWarnings("unchecked")
	public T idleConnections(java.lang.Integer value) {
		Object oldValue = this.idleConnections;
		this.idleConnections = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("idleConnections", oldValue, value);
		return (T) this;
	}

	/**
	 * This hint allows sizing of byte buffers when serializing and
	 * deserializing keys, to minimize array resizing.
	 */
	@ModelNodeBinding(detypedName = "key-size-estimate")
	public Integer keySizeEstimate() {
		return this.keySizeEstimate;
	}

	/**
	 * This hint allows sizing of byte buffers when serializing and
	 * deserializing keys, to minimize array resizing.
	 */
	@SuppressWarnings("unchecked")
	public T keySizeEstimate(java.lang.Integer value) {
		Object oldValue = this.keySizeEstimate;
		this.keySizeEstimate = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keySizeEstimate", oldValue, value);
		return (T) this;
	}

	/**
	 * Sets the maximum number of retries for each request. A valid value should
	 * be greater or equals than 0. Zero means no retry will made in case of a
	 * network failure.
	 */
	@ModelNodeBinding(detypedName = "max-retries")
	public Integer maxRetries() {
		return this.maxRetries;
	}

	/**
	 * Sets the maximum number of retries for each request. A valid value should
	 * be greater or equals than 0. Zero means no retry will made in case of a
	 * network failure.
	 */
	@SuppressWarnings("unchecked")
	public T maxRetries(java.lang.Integer value) {
		Object oldValue = this.maxRetries;
		this.maxRetries = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxRetries", oldValue, value);
		return (T) this;
	}

	/**
	 * Defines the module whose class loader should be used when configuring
	 * remote cache container marshaller.
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * Defines the module whose class loader should be used when configuring
	 * remote cache container marshaller.
	 */
	@SuppressWarnings("unchecked")
	public T module(java.lang.String value) {
		Object oldValue = this.module;
		this.module = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("module", oldValue, value);
		return (T) this;
	}

	/**
	 * This property defines the protocol version that this client should use.
	 */
	@ModelNodeBinding(detypedName = "protocol-version")
	public ProtocolVersion protocolVersion() {
		return this.protocolVersion;
	}

	/**
	 * This property defines the protocol version that this client should use.
	 */
	@SuppressWarnings("unchecked")
	public T protocolVersion(ProtocolVersion value) {
		Object oldValue = this.protocolVersion;
		this.protocolVersion = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("protocolVersion", oldValue, value);
		return (T) this;
	}

	/**
	 * Enable or disable SO_TIMEOUT on socket connections to remote Hot Rod
	 * servers with the specified timeout, in milliseconds. A timeout of 0 is
	 * interpreted as an infinite timeout.
	 */
	@ModelNodeBinding(detypedName = "socket-timeout")
	public Integer socketTimeout() {
		return this.socketTimeout;
	}

	/**
	 * Enable or disable SO_TIMEOUT on socket connections to remote Hot Rod
	 * servers with the specified timeout, in milliseconds. A timeout of 0 is
	 * interpreted as an infinite timeout.
	 */
	@SuppressWarnings("unchecked")
	public T socketTimeout(java.lang.Integer value) {
		Object oldValue = this.socketTimeout;
		this.socketTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("socketTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * Enables statistics gathering for this remote cache.
	 */
	@ModelNodeBinding(detypedName = "statistics-enabled")
	public Boolean statisticsEnabled() {
		return this.statisticsEnabled;
	}

	/**
	 * Enables statistics gathering for this remote cache.
	 */
	@SuppressWarnings("unchecked")
	public T statisticsEnabled(java.lang.Boolean value) {
		Object oldValue = this.statisticsEnabled;
		this.statisticsEnabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("statisticsEnabled", oldValue, value);
		return (T) this;
	}

	/**
	 * Configures TCP Keepalive on the TCP stack.
	 */
	@ModelNodeBinding(detypedName = "tcp-keep-alive")
	public Boolean tcpKeepAlive() {
		return this.tcpKeepAlive;
	}

	/**
	 * Configures TCP Keepalive on the TCP stack.
	 */
	@SuppressWarnings("unchecked")
	public T tcpKeepAlive(java.lang.Boolean value) {
		Object oldValue = this.tcpKeepAlive;
		this.tcpKeepAlive = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("tcpKeepAlive", oldValue, value);
		return (T) this;
	}

	/**
	 * Enable or disable TCP_NODELAY on socket connections to remote Hot Rod
	 * servers.
	 */
	@ModelNodeBinding(detypedName = "tcp-no-delay")
	public Boolean tcpNoDelay() {
		return this.tcpNoDelay;
	}

	/**
	 * Enable or disable TCP_NODELAY on socket connections to remote Hot Rod
	 * servers.
	 */
	@SuppressWarnings("unchecked")
	public T tcpNoDelay(java.lang.Boolean value) {
		Object oldValue = this.tcpNoDelay;
		this.tcpNoDelay = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("tcpNoDelay", oldValue, value);
		return (T) this;
	}

	/**
	 * This hint allows sizing of byte buffers when serializing and
	 * deserializing values, to minimize array resizing.
	 */
	@ModelNodeBinding(detypedName = "value-size-estimate")
	public Integer valueSizeEstimate() {
		return this.valueSizeEstimate;
	}

	/**
	 * This hint allows sizing of byte buffers when serializing and
	 * deserializing values, to minimize array resizing.
	 */
	@SuppressWarnings("unchecked")
	public T valueSizeEstimate(java.lang.Integer value) {
		Object oldValue = this.valueSizeEstimate;
		this.valueSizeEstimate = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("valueSizeEstimate", oldValue, value);
		return (T) this;
	}
}