package org.wildfly.swarm.config.infinispan;

import org.wildfly.swarm.config.infinispan.RemoteCacheContainer;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface RemoteCacheContainerConsumer<T extends RemoteCacheContainer<T>> {

	/**
	 * Configure a pre-constructed instance of RemoteCacheContainer resource
	 * 
	 * @parameter Instance of RemoteCacheContainer to configure
	 * @return nothing
	 */
	void accept(T value);

	default RemoteCacheContainerConsumer<T> andThen(
			RemoteCacheContainerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}