package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.infinispan.cache_container.BinaryMemory;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface BinaryMemoryConsumer<T extends BinaryMemory<T>> {

	/**
	 * Configure a pre-constructed instance of BinaryMemory resource
	 * 
	 * @parameter Instance of BinaryMemory to configure
	 * @return nothing
	 */
	void accept(T value);

	default BinaryMemoryConsumer<T> andThen(BinaryMemoryConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}