package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.infinispan.cache_container.cache.PersistenceComponent;
import org.wildfly.swarm.config.infinispan.cache_container.cache.PersistenceComponentConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.cache.PersistenceComponentSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.cache.TransactionComponent;
import org.wildfly.swarm.config.infinispan.cache_container.cache.TransactionComponentConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.cache.TransactionComponentSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.cache.PartitionHandlingComponent;
import org.wildfly.swarm.config.infinispan.cache_container.cache.PartitionHandlingComponentConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.cache.PartitionHandlingComponentSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.cache.LockingComponent;
import org.wildfly.swarm.config.infinispan.cache_container.cache.LockingComponentConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.cache.LockingComponentSupplier;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * The configuration of the infinispan subsystem.
 */
@Address("/subsystem=infinispan/cache-container=*/cache=*")
@ResourceType("cache")
public class Cache<T extends Cache<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private CacheResources subresources = new CacheResources();
	@AttributeDocumentation("The number of cache node activations (bringing a node into memory from a cache store).")
	private Long activations;
	@AttributeDocumentation("Average time (in ms) for cache reads. Includes hits and misses.")
	private Long averageReadTime;
	@AttributeDocumentation("Average time (in ms) for cache removes.")
	private Long averageRemoveTime;
	@AttributeDocumentation("The average time taken to replicate data around the cluster.")
	private Long averageReplicationTime;
	@AttributeDocumentation("Average time (in ms) for cache writes.")
	private Long averageWriteTime;
	@AttributeDocumentation("The number of cache eviction operations.")
	private Long evictions;
	@AttributeDocumentation("The hit/miss ratio for the cache (hits/hits+misses).")
	private Double hitRatio;
	@AttributeDocumentation("The number of cache attribute hits.")
	private Long hits;
	@AttributeDocumentation("The number of cache invalidations.")
	private Long invalidations;
	@AttributeDocumentation("The number of cache attribute misses.")
	private Long misses;
	@AttributeDocumentation("The number of entries in the cache including passivated entries.")
	private Integer numberOfEntries;
	@AttributeDocumentation("The number of entries in the cache excluding passivated entries.")
	private Integer numberOfEntriesInMemory;
	@AttributeDocumentation("The number of cache node passivations (passivating a node from memory to a cache store).")
	private Long passivations;
	@AttributeDocumentation("The read/write ratio of the cache ((hits+misses)/stores).")
	private Double readWriteRatio;
	@AttributeDocumentation("The number of cache attribute remove hits.")
	private Long removeHits;
	@AttributeDocumentation("The number of cache attribute remove misses.")
	private Long removeMisses;
	@AttributeDocumentation("The number of times data was replicated around the cluster.")
	private Long replicationCount;
	@AttributeDocumentation("The number of data replication failures.")
	private Long replicationFailures;
	@AttributeDocumentation("The data replication success ratio (successes/successes+failures).")
	private Double successRatio;
	@AttributeDocumentation("Time (in secs) since cache statistics were reset.")
	private Long timeSinceReset;
	@AttributeDocumentation("Time (in secs) since cache was started.")
	private Long timeSinceStart;
	@AttributeDocumentation("The number of cache attribute put operations.")
	private Long writes;

	public Cache(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public CacheResources subresources() {
		return this.subresources;
	}

	/**
	 * The configuration of the infinispan subsystem.
	 */
	@SuppressWarnings("unchecked")
	public T persistenceComponent(PersistenceComponent value) {
		this.subresources.persistenceComponent = value;
		return (T) this;
	}

	/**
	 * The configuration of the infinispan subsystem.
	 */
	@SuppressWarnings("unchecked")
	public T persistenceComponent(PersistenceComponentConsumer consumer) {
		PersistenceComponent<? extends PersistenceComponent> child = new PersistenceComponent<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.persistenceComponent = child;
		return (T) this;
	}

	/**
	 * The configuration of the infinispan subsystem.
	 */
	@SuppressWarnings("unchecked")
	public T persistenceComponent() {
		PersistenceComponent<? extends PersistenceComponent> child = new PersistenceComponent<>();
		this.subresources.persistenceComponent = child;
		return (T) this;
	}

	/**
	 * The configuration of the infinispan subsystem.
	 */
	@SuppressWarnings("unchecked")
	public T persistenceComponent(PersistenceComponentSupplier supplier) {
		this.subresources.persistenceComponent = supplier.get();
		return (T) this;
	}

	/**
	 * The cache transaction configuration.
	 */
	@SuppressWarnings("unchecked")
	public T transactionComponent(TransactionComponent value) {
		this.subresources.transactionComponent = value;
		return (T) this;
	}

	/**
	 * The cache transaction configuration.
	 */
	@SuppressWarnings("unchecked")
	public T transactionComponent(TransactionComponentConsumer consumer) {
		TransactionComponent<? extends TransactionComponent> child = new TransactionComponent<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.transactionComponent = child;
		return (T) this;
	}

	/**
	 * The cache transaction configuration.
	 */
	@SuppressWarnings("unchecked")
	public T transactionComponent() {
		TransactionComponent<? extends TransactionComponent> child = new TransactionComponent<>();
		this.subresources.transactionComponent = child;
		return (T) this;
	}

	/**
	 * The cache transaction configuration.
	 */
	@SuppressWarnings("unchecked")
	public T transactionComponent(TransactionComponentSupplier supplier) {
		this.subresources.transactionComponent = supplier.get();
		return (T) this;
	}

	/**
	 * The partition handling configuration for distributed and replicated
	 * caches.
	 */
	@SuppressWarnings("unchecked")
	public T partitionHandlingComponent(PartitionHandlingComponent value) {
		this.subresources.partitionHandlingComponent = value;
		return (T) this;
	}

	/**
	 * The partition handling configuration for distributed and replicated
	 * caches.
	 */
	@SuppressWarnings("unchecked")
	public T partitionHandlingComponent(
			PartitionHandlingComponentConsumer consumer) {
		PartitionHandlingComponent<? extends PartitionHandlingComponent> child = new PartitionHandlingComponent<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.partitionHandlingComponent = child;
		return (T) this;
	}

	/**
	 * The partition handling configuration for distributed and replicated
	 * caches.
	 */
	@SuppressWarnings("unchecked")
	public T partitionHandlingComponent() {
		PartitionHandlingComponent<? extends PartitionHandlingComponent> child = new PartitionHandlingComponent<>();
		this.subresources.partitionHandlingComponent = child;
		return (T) this;
	}

	/**
	 * The partition handling configuration for distributed and replicated
	 * caches.
	 */
	@SuppressWarnings("unchecked")
	public T partitionHandlingComponent(
			PartitionHandlingComponentSupplier supplier) {
		this.subresources.partitionHandlingComponent = supplier.get();
		return (T) this;
	}

	/**
	 * The locking configuration of the cache.
	 */
	@SuppressWarnings("unchecked")
	public T lockingComponent(LockingComponent value) {
		this.subresources.lockingComponent = value;
		return (T) this;
	}

	/**
	 * The locking configuration of the cache.
	 */
	@SuppressWarnings("unchecked")
	public T lockingComponent(LockingComponentConsumer consumer) {
		LockingComponent<? extends LockingComponent> child = new LockingComponent<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.lockingComponent = child;
		return (T) this;
	}

	/**
	 * The locking configuration of the cache.
	 */
	@SuppressWarnings("unchecked")
	public T lockingComponent() {
		LockingComponent<? extends LockingComponent> child = new LockingComponent<>();
		this.subresources.lockingComponent = child;
		return (T) this;
	}

	/**
	 * The locking configuration of the cache.
	 */
	@SuppressWarnings("unchecked")
	public T lockingComponent(LockingComponentSupplier supplier) {
		this.subresources.lockingComponent = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for Cache
	 */
	public static class CacheResources {
		@SingletonResource
		@ResourceDocumentation("The configuration of the infinispan subsystem.")
		private PersistenceComponent persistenceComponent;
		@SingletonResource
		@ResourceDocumentation("The cache transaction configuration.")
		private TransactionComponent transactionComponent;
		@SingletonResource
		@ResourceDocumentation("The partition handling configuration for distributed and replicated caches.")
		private PartitionHandlingComponent partitionHandlingComponent;
		@SingletonResource
		@ResourceDocumentation("The locking configuration of the cache.")
		private LockingComponent lockingComponent;

		/**
		 * The configuration of the infinispan subsystem.
		 */
		@Subresource
		public PersistenceComponent persistenceComponent() {
			return this.persistenceComponent;
		}

		/**
		 * The cache transaction configuration.
		 */
		@Subresource
		public TransactionComponent transactionComponent() {
			return this.transactionComponent;
		}

		/**
		 * The partition handling configuration for distributed and replicated
		 * caches.
		 */
		@Subresource
		public PartitionHandlingComponent partitionHandlingComponent() {
			return this.partitionHandlingComponent;
		}

		/**
		 * The locking configuration of the cache.
		 */
		@Subresource
		public LockingComponent lockingComponent() {
			return this.lockingComponent;
		}
	}

	/**
	 * The number of cache node activations (bringing a node into memory from a
	 * cache store).
	 */
	@ModelNodeBinding(detypedName = "activations")
	public Long activations() {
		return this.activations;
	}

	/**
	 * The number of cache node activations (bringing a node into memory from a
	 * cache store).
	 */
	@SuppressWarnings("unchecked")
	public T activations(java.lang.Long value) {
		Object oldValue = this.activations;
		this.activations = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("activations", oldValue, value);
		return (T) this;
	}

	/**
	 * Average time (in ms) for cache reads. Includes hits and misses.
	 */
	@ModelNodeBinding(detypedName = "average-read-time")
	public Long averageReadTime() {
		return this.averageReadTime;
	}

	/**
	 * Average time (in ms) for cache reads. Includes hits and misses.
	 */
	@SuppressWarnings("unchecked")
	public T averageReadTime(java.lang.Long value) {
		Object oldValue = this.averageReadTime;
		this.averageReadTime = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("averageReadTime", oldValue, value);
		return (T) this;
	}

	/**
	 * Average time (in ms) for cache removes.
	 */
	@ModelNodeBinding(detypedName = "average-remove-time")
	public Long averageRemoveTime() {
		return this.averageRemoveTime;
	}

	/**
	 * Average time (in ms) for cache removes.
	 */
	@SuppressWarnings("unchecked")
	public T averageRemoveTime(java.lang.Long value) {
		Object oldValue = this.averageRemoveTime;
		this.averageRemoveTime = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("averageRemoveTime", oldValue, value);
		return (T) this;
	}

	/**
	 * The average time taken to replicate data around the cluster.
	 */
	@ModelNodeBinding(detypedName = "average-replication-time")
	public Long averageReplicationTime() {
		return this.averageReplicationTime;
	}

	/**
	 * The average time taken to replicate data around the cluster.
	 */
	@SuppressWarnings("unchecked")
	public T averageReplicationTime(java.lang.Long value) {
		Object oldValue = this.averageReplicationTime;
		this.averageReplicationTime = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("averageReplicationTime", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Average time (in ms) for cache writes.
	 */
	@ModelNodeBinding(detypedName = "average-write-time")
	public Long averageWriteTime() {
		return this.averageWriteTime;
	}

	/**
	 * Average time (in ms) for cache writes.
	 */
	@SuppressWarnings("unchecked")
	public T averageWriteTime(java.lang.Long value) {
		Object oldValue = this.averageWriteTime;
		this.averageWriteTime = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("averageWriteTime", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of cache eviction operations.
	 */
	@ModelNodeBinding(detypedName = "evictions")
	public Long evictions() {
		return this.evictions;
	}

	/**
	 * The number of cache eviction operations.
	 */
	@SuppressWarnings("unchecked")
	public T evictions(java.lang.Long value) {
		Object oldValue = this.evictions;
		this.evictions = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("evictions", oldValue, value);
		return (T) this;
	}

	/**
	 * The hit/miss ratio for the cache (hits/hits+misses).
	 */
	@ModelNodeBinding(detypedName = "hit-ratio")
	public Double hitRatio() {
		return this.hitRatio;
	}

	/**
	 * The hit/miss ratio for the cache (hits/hits+misses).
	 */
	@SuppressWarnings("unchecked")
	public T hitRatio(java.lang.Double value) {
		Object oldValue = this.hitRatio;
		this.hitRatio = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("hitRatio", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of cache attribute hits.
	 */
	@ModelNodeBinding(detypedName = "hits")
	public Long hits() {
		return this.hits;
	}

	/**
	 * The number of cache attribute hits.
	 */
	@SuppressWarnings("unchecked")
	public T hits(java.lang.Long value) {
		Object oldValue = this.hits;
		this.hits = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("hits", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of cache invalidations.
	 */
	@ModelNodeBinding(detypedName = "invalidations")
	public Long invalidations() {
		return this.invalidations;
	}

	/**
	 * The number of cache invalidations.
	 */
	@SuppressWarnings("unchecked")
	public T invalidations(java.lang.Long value) {
		Object oldValue = this.invalidations;
		this.invalidations = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("invalidations", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of cache attribute misses.
	 */
	@ModelNodeBinding(detypedName = "misses")
	public Long misses() {
		return this.misses;
	}

	/**
	 * The number of cache attribute misses.
	 */
	@SuppressWarnings("unchecked")
	public T misses(java.lang.Long value) {
		Object oldValue = this.misses;
		this.misses = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("misses", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of entries in the cache including passivated entries.
	 */
	@ModelNodeBinding(detypedName = "number-of-entries")
	public Integer numberOfEntries() {
		return this.numberOfEntries;
	}

	/**
	 * The number of entries in the cache including passivated entries.
	 */
	@SuppressWarnings("unchecked")
	public T numberOfEntries(java.lang.Integer value) {
		Object oldValue = this.numberOfEntries;
		this.numberOfEntries = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("numberOfEntries", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of entries in the cache excluding passivated entries.
	 */
	@ModelNodeBinding(detypedName = "number-of-entries-in-memory")
	public Integer numberOfEntriesInMemory() {
		return this.numberOfEntriesInMemory;
	}

	/**
	 * The number of entries in the cache excluding passivated entries.
	 */
	@SuppressWarnings("unchecked")
	public T numberOfEntriesInMemory(java.lang.Integer value) {
		Object oldValue = this.numberOfEntriesInMemory;
		this.numberOfEntriesInMemory = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("numberOfEntriesInMemory", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The number of cache node passivations (passivating a node from memory to
	 * a cache store).
	 */
	@ModelNodeBinding(detypedName = "passivations")
	public Long passivations() {
		return this.passivations;
	}

	/**
	 * The number of cache node passivations (passivating a node from memory to
	 * a cache store).
	 */
	@SuppressWarnings("unchecked")
	public T passivations(java.lang.Long value) {
		Object oldValue = this.passivations;
		this.passivations = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("passivations", oldValue, value);
		return (T) this;
	}

	/**
	 * The read/write ratio of the cache ((hits+misses)/stores).
	 */
	@ModelNodeBinding(detypedName = "read-write-ratio")
	public Double readWriteRatio() {
		return this.readWriteRatio;
	}

	/**
	 * The read/write ratio of the cache ((hits+misses)/stores).
	 */
	@SuppressWarnings("unchecked")
	public T readWriteRatio(java.lang.Double value) {
		Object oldValue = this.readWriteRatio;
		this.readWriteRatio = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("readWriteRatio", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of cache attribute remove hits.
	 */
	@ModelNodeBinding(detypedName = "remove-hits")
	public Long removeHits() {
		return this.removeHits;
	}

	/**
	 * The number of cache attribute remove hits.
	 */
	@SuppressWarnings("unchecked")
	public T removeHits(java.lang.Long value) {
		Object oldValue = this.removeHits;
		this.removeHits = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("removeHits", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of cache attribute remove misses.
	 */
	@ModelNodeBinding(detypedName = "remove-misses")
	public Long removeMisses() {
		return this.removeMisses;
	}

	/**
	 * The number of cache attribute remove misses.
	 */
	@SuppressWarnings("unchecked")
	public T removeMisses(java.lang.Long value) {
		Object oldValue = this.removeMisses;
		this.removeMisses = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("removeMisses", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of times data was replicated around the cluster.
	 */
	@ModelNodeBinding(detypedName = "replication-count")
	public Long replicationCount() {
		return this.replicationCount;
	}

	/**
	 * The number of times data was replicated around the cluster.
	 */
	@SuppressWarnings("unchecked")
	public T replicationCount(java.lang.Long value) {
		Object oldValue = this.replicationCount;
		this.replicationCount = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("replicationCount", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of data replication failures.
	 */
	@ModelNodeBinding(detypedName = "replication-failures")
	public Long replicationFailures() {
		return this.replicationFailures;
	}

	/**
	 * The number of data replication failures.
	 */
	@SuppressWarnings("unchecked")
	public T replicationFailures(java.lang.Long value) {
		Object oldValue = this.replicationFailures;
		this.replicationFailures = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("replicationFailures", oldValue, value);
		return (T) this;
	}

	/**
	 * The data replication success ratio (successes/successes+failures).
	 */
	@ModelNodeBinding(detypedName = "success-ratio")
	public Double successRatio() {
		return this.successRatio;
	}

	/**
	 * The data replication success ratio (successes/successes+failures).
	 */
	@SuppressWarnings("unchecked")
	public T successRatio(java.lang.Double value) {
		Object oldValue = this.successRatio;
		this.successRatio = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("successRatio", oldValue, value);
		return (T) this;
	}

	/**
	 * Time (in secs) since cache statistics were reset.
	 */
	@ModelNodeBinding(detypedName = "time-since-reset")
	public Long timeSinceReset() {
		return this.timeSinceReset;
	}

	/**
	 * Time (in secs) since cache statistics were reset.
	 */
	@SuppressWarnings("unchecked")
	public T timeSinceReset(java.lang.Long value) {
		Object oldValue = this.timeSinceReset;
		this.timeSinceReset = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("timeSinceReset", oldValue, value);
		return (T) this;
	}

	/**
	 * Time (in secs) since cache was started.
	 */
	@ModelNodeBinding(detypedName = "time-since-start")
	public Long timeSinceStart() {
		return this.timeSinceStart;
	}

	/**
	 * Time (in secs) since cache was started.
	 */
	@SuppressWarnings("unchecked")
	public T timeSinceStart(java.lang.Long value) {
		Object oldValue = this.timeSinceStart;
		this.timeSinceStart = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("timeSinceStart", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of cache attribute put operations.
	 */
	@ModelNodeBinding(detypedName = "writes")
	public Long writes() {
		return this.writes;
	}

	/**
	 * The number of cache attribute put operations.
	 */
	@SuppressWarnings("unchecked")
	public T writes(java.lang.Long value) {
		Object oldValue = this.writes;
		this.writes = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("writes", oldValue, value);
		return (T) this;
	}
}