package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.infinispan.cache_container.HotrodStore;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface HotrodStoreConsumer<T extends HotrodStore<T>> {

	/**
	 * Configure a pre-constructed instance of HotrodStore resource
	 * 
	 * @parameter Instance of HotrodStore to configure
	 * @return nothing
	 */
	void accept(T value);

	default HotrodStoreConsumer<T> andThen(HotrodStoreConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}