package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * The description of the transport used by this cache container
 */
@Address("/subsystem=infinispan/cache-container=*/transport=jgroups")
@ResourceType("transport")
@Implicit
public class JGroupsTransport<T extends JGroupsTransport<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The channel of this cache container's transport.")
	private String channel;
	@AttributeDocumentation("The name of the group communication cluster")
	private String cluster;
	@AttributeDocumentation("The executor to use for the transport")
	private String executor;
	@AttributeDocumentation("The timeout for locks for the transport")
	private Long lockTimeout;
	@AttributeDocumentation("The jgroups stack to use for the transport")
	private String stack;

	public JGroupsTransport() {
		super();
		this.key = "jgroups";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The channel of this cache container's transport.
	 */
	@ModelNodeBinding(detypedName = "channel")
	public String channel() {
		return this.channel;
	}

	/**
	 * The channel of this cache container's transport.
	 */
	@SuppressWarnings("unchecked")
	public T channel(java.lang.String value) {
		Object oldValue = this.channel;
		this.channel = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("channel", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the group communication cluster
	 * 
	 * @deprecated Deprecated. The cluster used by the transport of this cache
	 *             container is configured via the JGroups subsystem.
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "cluster")
	public String cluster() {
		return this.cluster;
	}

	/**
	 * The name of the group communication cluster
	 * 
	 * @deprecated Deprecated. The cluster used by the transport of this cache
	 *             container is configured via the JGroups subsystem.
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T cluster(java.lang.String value) {
		Object oldValue = this.cluster;
		this.cluster = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("cluster", oldValue, value);
		return (T) this;
	}

	/**
	 * The executor to use for the transport
	 * 
	 * @deprecated Deprecated. This will be replaced by thread pool
	 *             configuration embedded in the subsystem in a future release.
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "executor")
	public String executor() {
		return this.executor;
	}

	/**
	 * The executor to use for the transport
	 * 
	 * @deprecated Deprecated. This will be replaced by thread pool
	 *             configuration embedded in the subsystem in a future release.
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T executor(java.lang.String value) {
		Object oldValue = this.executor;
		this.executor = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("executor", oldValue, value);
		return (T) this;
	}

	/**
	 * The timeout for locks for the transport
	 */
	@ModelNodeBinding(detypedName = "lock-timeout")
	public Long lockTimeout() {
		return this.lockTimeout;
	}

	/**
	 * The timeout for locks for the transport
	 */
	@SuppressWarnings("unchecked")
	public T lockTimeout(java.lang.Long value) {
		Object oldValue = this.lockTimeout;
		this.lockTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("lockTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * The jgroups stack to use for the transport
	 * 
	 * @deprecated Deprecated. The protocol stack used by the transport of this
	 *             cache container is configured via the JGroups subsystem.
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "stack")
	public String stack() {
		return this.stack;
	}

	/**
	 * The jgroups stack to use for the transport
	 * 
	 * @deprecated Deprecated. The protocol stack used by the transport of this
	 *             cache container is configured via the JGroups subsystem.
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T stack(java.lang.String value) {
		Object oldValue = this.stack;
		this.stack = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("stack", oldValue, value);
		return (T) this;
	}
}