package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * On-heap object-based memory configuration.
 */
@Addresses({
		"/subsystem=infinispan/cache-container=*/invalidation-cache=*/memory=object",
		"/subsystem=infinispan/cache-container=*/local-cache=*/memory=object",
		"/subsystem=infinispan/cache-container=*/replicated-cache=*/memory=object",
		"/subsystem=infinispan/cache-container=*/distributed-cache=*/memory=object",
		"/subsystem=infinispan/cache-container=*/scattered-cache=*/memory=object"})
@ResourceType("memory")
@Implicit
public class ObjectMemory<T extends ObjectMemory<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The number of cache eviction operations.")
	private Long evictions;
	@AttributeDocumentation("Maximum number of entries in a cache instance. If selected value is not a power of two the actual value will default to the least power of two larger than selected value. -1 means no limit.")
	private Long maxEntries;
	@AttributeDocumentation("Triggers eviction of the least recently used entries when the number of cache entries exceeds this threshold.")
	private Long size;
	@AttributeDocumentation("Sets the cache eviction strategy. Available options are 'UNORDERED', 'FIFO', 'LRU', 'LIRS' and 'NONE' (to disable eviction).")
	private String strategy;

	public ObjectMemory() {
		super();
		this.key = "object";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The number of cache eviction operations.
	 * 
	 * @deprecated Deprecated. Use corresponding metric on parent resource.
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "evictions")
	public Long evictions() {
		return this.evictions;
	}

	/**
	 * The number of cache eviction operations.
	 * 
	 * @deprecated Deprecated. Use corresponding metric on parent resource.
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T evictions(java.lang.Long value) {
		Object oldValue = this.evictions;
		this.evictions = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("evictions", oldValue, value);
		return (T) this;
	}

	/**
	 * Maximum number of entries in a cache instance. If selected value is not a
	 * power of two the actual value will default to the least power of two
	 * larger than selected value. -1 means no limit.
	 * 
	 * @deprecated Deprecated. Use the size attribute instead.
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "max-entries")
	public Long maxEntries() {
		return this.maxEntries;
	}

	/**
	 * Maximum number of entries in a cache instance. If selected value is not a
	 * power of two the actual value will default to the least power of two
	 * larger than selected value. -1 means no limit.
	 * 
	 * @deprecated Deprecated. Use the size attribute instead.
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T maxEntries(java.lang.Long value) {
		Object oldValue = this.maxEntries;
		this.maxEntries = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxEntries", oldValue, value);
		return (T) this;
	}

	/**
	 * Triggers eviction of the least recently used entries when the number of
	 * cache entries exceeds this threshold.
	 */
	@ModelNodeBinding(detypedName = "size")
	public Long size() {
		return this.size;
	}

	/**
	 * Triggers eviction of the least recently used entries when the number of
	 * cache entries exceeds this threshold.
	 */
	@SuppressWarnings("unchecked")
	public T size(java.lang.Long value) {
		Object oldValue = this.size;
		this.size = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("size", oldValue, value);
		return (T) this;
	}

	/**
	 * Sets the cache eviction strategy. Available options are 'UNORDERED',
	 * 'FIFO', 'LRU', 'LIRS' and 'NONE' (to disable eviction).
	 * 
	 * @deprecated Deprecated. Eviction uses LRU and is disabled via undefining
	 *             the size attribute.
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "strategy")
	public String strategy() {
		return this.strategy;
	}

	/**
	 * Sets the cache eviction strategy. Available options are 'UNORDERED',
	 * 'FIFO', 'LRU', 'LIRS' and 'NONE' (to disable eviction).
	 * 
	 * @deprecated Deprecated. Eviction uses LRU and is disabled via undefining
	 *             the size attribute.
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T strategy(java.lang.String value) {
		Object oldValue = this.strategy;
		this.strategy = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("strategy", oldValue, value);
		return (T) this;
	}
}