package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.infinispan.cache_container.ScatteredCache;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ScatteredCacheConsumer<T extends ScatteredCache<T>> {

	/**
	 * Configure a pre-constructed instance of ScatteredCache resource
	 * 
	 * @parameter Instance of ScatteredCache to configure
	 * @return nothing
	 */
	void accept(T value);

	default ScatteredCacheConsumer<T> andThen(ScatteredCacheConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}