package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * The state transfer configuration for distributed and replicated caches.
 */
@Addresses({
		"/subsystem=infinispan/cache-container=*/replicated-cache=*/component=state-transfer",
		"/subsystem=infinispan/cache-container=*/distributed-cache=*/component=state-transfer",
		"/subsystem=infinispan/cache-container=*/scattered-cache=*/component=state-transfer"})
@ResourceType("component")
@Implicit
public class StateTransferComponent<T extends StateTransferComponent<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The maximum number of cache entries in a batch of transferred state.")
	private Integer chunkSize;
	@AttributeDocumentation("If enabled, this will cause the cache to ask neighboring caches for state when it starts up, so the cache starts 'warm', although it will impact startup time.")
	private Boolean enabled;
	@AttributeDocumentation("The maximum amount of time (ms) to wait for state from neighboring caches, before throwing an exception and aborting startup. If timeout is 0, state transfer is performed asynchronously, and the cache will be immediately available.")
	private Long timeout;

	public StateTransferComponent() {
		super();
		this.key = "state-transfer";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The maximum number of cache entries in a batch of transferred state.
	 */
	@ModelNodeBinding(detypedName = "chunk-size")
	public Integer chunkSize() {
		return this.chunkSize;
	}

	/**
	 * The maximum number of cache entries in a batch of transferred state.
	 */
	@SuppressWarnings("unchecked")
	public T chunkSize(java.lang.Integer value) {
		Object oldValue = this.chunkSize;
		this.chunkSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("chunkSize", oldValue, value);
		return (T) this;
	}

	/**
	 * If enabled, this will cause the cache to ask neighboring caches for state
	 * when it starts up, so the cache starts 'warm', although it will impact
	 * startup time.
	 * 
	 * @deprecated Deprecated. Always enabled for replicated and distributed
	 *             caches.
	 */
	@Deprecated
	@ModelNodeBinding(detypedName = "enabled")
	public Boolean enabled() {
		return this.enabled;
	}

	/**
	 * If enabled, this will cause the cache to ask neighboring caches for state
	 * when it starts up, so the cache starts 'warm', although it will impact
	 * startup time.
	 * 
	 * @deprecated Deprecated. Always enabled for replicated and distributed
	 *             caches.
	 */
	@SuppressWarnings("unchecked")
	@Deprecated
	public T enabled(java.lang.Boolean value) {
		Object oldValue = this.enabled;
		this.enabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("enabled", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum amount of time (ms) to wait for state from neighboring
	 * caches, before throwing an exception and aborting startup. If timeout is
	 * 0, state transfer is performed asynchronously, and the cache will be
	 * immediately available.
	 */
	@ModelNodeBinding(detypedName = "timeout")
	public Long timeout() {
		return this.timeout;
	}

	/**
	 * The maximum amount of time (ms) to wait for state from neighboring
	 * caches, before throwing an exception and aborting startup. If timeout is
	 * 0, state transfer is performed asynchronously, and the cache will be
	 * immediately available.
	 */
	@SuppressWarnings("unchecked")
	public T timeout(java.lang.Long value) {
		Object oldValue = this.timeout;
		this.timeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("timeout", oldValue, value);
		return (T) this;
	}
}