package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.infinispan.cache_container.ThroughWrite;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ThroughWriteConsumer<T extends ThroughWrite<T>> {

	/**
	 * Configure a pre-constructed instance of ThroughWrite resource
	 * 
	 * @parameter Instance of ThroughWrite to configure
	 * @return nothing
	 */
	void accept(T value);

	default ThroughWriteConsumer<T> andThen(ThroughWriteConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}