package org.wildfly.swarm.config.infinispan.cache_container.cache;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * The locking configuration of the cache.
 */
@Address("/subsystem=infinispan/cache-container=*/cache=*/component=locking")
@ResourceType("component")
@Implicit
public class LockingComponent<T extends LockingComponent<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The estimated number of concurrently updating threads which this cache can support.")
	private Integer currentConcurrencyLevel;
	@AttributeDocumentation("The number of locks available to this cache.")
	private Integer numberOfLocksAvailable;
	@AttributeDocumentation("The number of locks currently in use by this cache.")
	private Integer numberOfLocksHeld;

	public LockingComponent() {
		super();
		this.key = "locking";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The estimated number of concurrently updating threads which this cache
	 * can support.
	 */
	@ModelNodeBinding(detypedName = "current-concurrency-level")
	public Integer currentConcurrencyLevel() {
		return this.currentConcurrencyLevel;
	}

	/**
	 * The estimated number of concurrently updating threads which this cache
	 * can support.
	 */
	@SuppressWarnings("unchecked")
	public T currentConcurrencyLevel(java.lang.Integer value) {
		Object oldValue = this.currentConcurrencyLevel;
		this.currentConcurrencyLevel = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("currentConcurrencyLevel", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The number of locks available to this cache.
	 */
	@ModelNodeBinding(detypedName = "number-of-locks-available")
	public Integer numberOfLocksAvailable() {
		return this.numberOfLocksAvailable;
	}

	/**
	 * The number of locks available to this cache.
	 */
	@SuppressWarnings("unchecked")
	public T numberOfLocksAvailable(java.lang.Integer value) {
		Object oldValue = this.numberOfLocksAvailable;
		this.numberOfLocksAvailable = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("numberOfLocksAvailable", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The number of locks currently in use by this cache.
	 */
	@ModelNodeBinding(detypedName = "number-of-locks-held")
	public Integer numberOfLocksHeld() {
		return this.numberOfLocksHeld;
	}

	/**
	 * The number of locks currently in use by this cache.
	 */
	@SuppressWarnings("unchecked")
	public T numberOfLocksHeld(java.lang.Integer value) {
		Object oldValue = this.numberOfLocksHeld;
		this.numberOfLocksHeld = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("numberOfLocksHeld", oldValue, value);
		return (T) this;
	}
}