package org.wildfly.swarm.config.infinispan.cache_container.cache;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * The partition handling configuration for distributed and replicated caches.
 */
@Address("/subsystem=infinispan/cache-container=*/cache=*/component=partition-handling")
@ResourceType("component")
@Implicit
public class PartitionHandlingComponent<T extends PartitionHandlingComponent<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Indicates the current availability of the cache.")
	private String availability;

	public PartitionHandlingComponent() {
		super();
		this.key = "partition-handling";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Indicates the current availability of the cache.
	 */
	@ModelNodeBinding(detypedName = "availability")
	public String availability() {
		return this.availability;
	}

	/**
	 * Indicates the current availability of the cache.
	 */
	@SuppressWarnings("unchecked")
	public T availability(java.lang.String value) {
		Object oldValue = this.availability;
		this.availability = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("availability", oldValue, value);
		return (T) this;
	}
}