package org.wildfly.swarm.config.infinispan.cache_container.cache;

import org.wildfly.swarm.config.infinispan.cache_container.cache.PartitionHandlingComponent;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface PartitionHandlingComponentConsumer<T extends PartitionHandlingComponent<T>> {

	/**
	 * Configure a pre-constructed instance of PartitionHandlingComponent
	 * resource
	 * 
	 * @parameter Instance of PartitionHandlingComponent to configure
	 * @return nothing
	 */
	void accept(T value);

	default PartitionHandlingComponentConsumer<T> andThen(
			PartitionHandlingComponentConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}