package org.wildfly.swarm.config.infinispan.cache_container.cache;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * The configuration of the infinispan subsystem.
 */
@Address("/subsystem=infinispan/cache-container=*/cache=*/component=persistence")
@ResourceType("component")
@Implicit
public class PersistenceComponent<T extends PersistenceComponent<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The number of cache loader node loads.")
	private Long cacheLoaderLoads;
	@AttributeDocumentation("The number of cache loader node misses.")
	private Long cacheLoaderMisses;

	public PersistenceComponent() {
		super();
		this.key = "persistence";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The number of cache loader node loads.
	 */
	@ModelNodeBinding(detypedName = "cache-loader-loads")
	public Long cacheLoaderLoads() {
		return this.cacheLoaderLoads;
	}

	/**
	 * The number of cache loader node loads.
	 */
	@SuppressWarnings("unchecked")
	public T cacheLoaderLoads(java.lang.Long value) {
		Object oldValue = this.cacheLoaderLoads;
		this.cacheLoaderLoads = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("cacheLoaderLoads", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of cache loader node misses.
	 */
	@ModelNodeBinding(detypedName = "cache-loader-misses")
	public Long cacheLoaderMisses() {
		return this.cacheLoaderMisses;
	}

	/**
	 * The number of cache loader node misses.
	 */
	@SuppressWarnings("unchecked")
	public T cacheLoaderMisses(java.lang.Long value) {
		Object oldValue = this.cacheLoaderMisses;
		this.cacheLoaderMisses = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("cacheLoaderMisses", oldValue, value);
		return (T) this;
	}
}